/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.step;

import java.util.ArrayList;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversionFactory;
import org.activiti.workflow.simple.converter.step.BaseStepDefinitionConverter;
import org.activiti.workflow.simple.definition.ChoiceStepsDefinition;
import org.activiti.workflow.simple.definition.ConditionDefinition;
import org.activiti.workflow.simple.definition.ListConditionStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;

public class ChoiceStepsDefinitionConverter
extends BaseStepDefinitionConverter<ChoiceStepsDefinition, ExclusiveGateway> {
    private static final long serialVersionUID = 1L;
    private static final String EXLCUSIVE_GATEWAY_PREFIX = "exclusiveGateway";

    @Override
    public Class<? extends StepDefinition> getHandledClass() {
        return ChoiceStepsDefinition.class;
    }

    @Override
    protected ExclusiveGateway createProcessArtifact(ChoiceStepsDefinition choiceStepsDefinition, WorkflowDefinitionConversion conversion) {
        ExclusiveGateway forkGateway = this.createExclusiveGateway(conversion);
        this.addSequenceFlow(conversion, conversion.getLastActivityId(), forkGateway.getId());
        conversion.setLastActivityId(forkGateway.getId());
        WorkflowDefinitionConversionFactory conversionFactory = conversion.getConversionFactory();
        ArrayList<FlowElement> endElements = new ArrayList<FlowElement>();
        ArrayList<SequenceFlow> bypassingFlows = new ArrayList<SequenceFlow>();
        for (ListConditionStepDefinition stepListDefinition : choiceStepsDefinition.getStepList()) {
            StringBuilder conditionBuilder = new StringBuilder();
            for (ConditionDefinition conditionDefintion : stepListDefinition.getConditions()) {
                if (conditionBuilder.length() > 0) {
                    conditionBuilder.append(" && ");
                } else {
                    conditionBuilder.append("${");
                }
                conditionBuilder.append(conditionDefintion.getLeftOperand());
                conditionBuilder.append(" ");
                conditionBuilder.append(conditionDefintion.getOperator());
                conditionBuilder.append(" ");
                conditionBuilder.append(conditionDefintion.getRightOperand());
            }
            for (int i = 0; i < stepListDefinition.getSteps().size(); ++i) {
                if (i == 0) {
                    conversion.setSequenceflowGenerationEnabled(false);
                } else {
                    conversion.setSequenceflowGenerationEnabled(true);
                }
                StepDefinition step = stepListDefinition.getSteps().get(i);
                FlowElement flowElement = (FlowElement)conversionFactory.getStepConverterFor(step).convertStepDefinition(step, conversion);
                if (i == 0) {
                    if (conditionBuilder.length() > 0) {
                        conditionBuilder.append("}");
                        SequenceFlow mainFlow = this.addSequenceFlow(conversion, forkGateway.getId(), flowElement.getId(), conditionBuilder.toString());
                        if (stepListDefinition.getName() != null) {
                            mainFlow.setName(stepListDefinition.getName());
                        }
                    } else {
                        this.addSequenceFlow(conversion, forkGateway.getId(), flowElement.getId());
                    }
                }
                if (i + 1 != stepListDefinition.getSteps().size()) continue;
                endElements.add(flowElement);
            }
            if (!stepListDefinition.getSteps().isEmpty()) continue;
            SequenceFlow created = null;
            if (conditionBuilder.length() > 0) {
                conditionBuilder.append("}");
                created = this.addSequenceFlow(conversion, forkGateway.getId(), null, conditionBuilder.toString());
            } else {
                created = this.addSequenceFlow(conversion, forkGateway.getId(), null);
            }
            if (stepListDefinition.getName() != null) {
                created.setName(stepListDefinition.getName());
            }
            bypassingFlows.add(created);
        }
        conversion.setSequenceflowGenerationEnabled(false);
        ExclusiveGateway joinGateway = this.createExclusiveGateway(conversion);
        conversion.setLastActivityId(joinGateway.getId());
        conversion.setSequenceflowGenerationEnabled(true);
        for (FlowElement endElement : endElements) {
            if (endElement instanceof EndEvent) continue;
            this.addSequenceFlow(conversion, endElement.getId(), joinGateway.getId());
        }
        for (SequenceFlow bypassingFlow : bypassingFlows) {
            bypassingFlow.setTargetRef(joinGateway.getId());
        }
        return forkGateway;
    }

    protected ExclusiveGateway createExclusiveGateway(WorkflowDefinitionConversion conversion) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(conversion.getUniqueNumberedId(EXLCUSIVE_GATEWAY_PREFIX));
        conversion.getProcess().addFlowElement((FlowElement)exclusiveGateway);
        return exclusiveGateway;
    }
}

