/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.activiti.workflow.simple.definition.ChoiceStepsDefinition;
import org.activiti.workflow.simple.definition.DelayStepDefinition;
import org.activiti.workflow.simple.definition.FeedbackStepDefinition;
import org.activiti.workflow.simple.definition.HumanStepDefinition;
import org.activiti.workflow.simple.definition.ListConditionStepDefinition;
import org.activiti.workflow.simple.definition.ListStepDefinition;
import org.activiti.workflow.simple.definition.ParallelStepsDefinition;
import org.activiti.workflow.simple.definition.ScriptStepDefinition;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.activiti.workflow.simple.definition.form.BooleanPropertyDefinition;
import org.activiti.workflow.simple.definition.form.DatePropertyDefinition;
import org.activiti.workflow.simple.definition.form.FormDefinition;
import org.activiti.workflow.simple.definition.form.ListPropertyDefinition;
import org.activiti.workflow.simple.definition.form.NumberPropertyDefinition;
import org.activiti.workflow.simple.definition.form.ReferencePropertyDefinition;
import org.activiti.workflow.simple.definition.form.TextPropertyDefinition;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

public class SimpleWorkflowJsonConverter {
    protected ObjectMapper objectMapper;
    protected List<Class<?>> additionalModelClasses;

    public WorkflowDefinition readWorkflowDefinition(InputStream inputStream) throws SimpleWorkflowException {
        try {
            return (WorkflowDefinition)this.getObjectMapper().readValue(inputStream, WorkflowDefinition.class);
        }
        catch (Exception e) {
            throw this.wrapExceptionRead(e);
        }
    }

    public WorkflowDefinition readWorkflowDefinition(byte[] bytes) throws SimpleWorkflowException {
        try {
            return (WorkflowDefinition)this.getObjectMapper().readValue(bytes, WorkflowDefinition.class);
        }
        catch (Exception e) {
            throw this.wrapExceptionRead(e);
        }
    }

    public void writeWorkflowDefinition(WorkflowDefinition definition, Writer writer) {
        try {
            this.getObjectMapper().writeValue(writer, (Object)definition);
        }
        catch (Exception e) {
            throw this.wrapExceptionWrite(e);
        }
    }

    public FormDefinition readFormDefinition(InputStream inputStream) {
        try {
            return (FormDefinition)this.getObjectMapper().readValue(inputStream, FormDefinition.class);
        }
        catch (Exception e) {
            throw this.wrapExceptionRead(e);
        }
    }

    public void writeFormDefinition(FormDefinition definition, Writer writer) {
        try {
            this.getObjectMapper().writeValue(writer, (Object)definition);
        }
        catch (Exception e) {
            throw this.wrapExceptionWrite(e);
        }
    }

    protected SimpleWorkflowException wrapExceptionRead(Exception e) {
        return new SimpleWorkflowException("Error while parsing JSON", e);
    }

    protected SimpleWorkflowException wrapExceptionWrite(Exception e) {
        return new SimpleWorkflowException("Error while writing JSON", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            SimpleWorkflowJsonConverter simpleWorkflowJsonConverter = this;
            synchronized (simpleWorkflowJsonConverter) {
                if (this.objectMapper == null) {
                    this.objectMapper = new ObjectMapper();
                    this.objectMapper.registerSubtypes(new Class[]{ListPropertyDefinition.class, TextPropertyDefinition.class, ReferencePropertyDefinition.class, DatePropertyDefinition.class, NumberPropertyDefinition.class, BooleanPropertyDefinition.class});
                    this.objectMapper.registerSubtypes(new Class[]{HumanStepDefinition.class, FeedbackStepDefinition.class, ParallelStepsDefinition.class, ChoiceStepsDefinition.class, ListStepDefinition.class, ListConditionStepDefinition.class, ScriptStepDefinition.class, DelayStepDefinition.class});
                    if (this.additionalModelClasses != null) {
                        this.objectMapper.registerSubtypes(this.additionalModelClasses.toArray(new Class[0]));
                    }
                }
            }
        }
        return this.objectMapper;
    }
}

