/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl;

import java.util.Map;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProcessByKeyEventHandler
implements SimulationEventHandler {
    private static Logger log = LoggerFactory.getLogger(StartProcessByKeyEventHandler.class);
    protected String processToStartKey;
    protected String businessKey;
    protected String variablesKey;

    public StartProcessByKeyEventHandler(String processToStartKey, String businessKey, String variablesKey) {
        this.processToStartKey = processToStartKey;
        this.businessKey = businessKey;
        this.variablesKey = variablesKey;
    }

    @Override
    public void init() {
    }

    @Override
    public void handle(SimulationEvent event) {
        String processDefinitionKey = (String)event.getProperty(this.processToStartKey);
        String businessKey = (String)event.getProperty(this.businessKey);
        Map variables = (Map)event.getProperty(this.variablesKey);
        log.debug("Starting new processDefKey[{}] businessKey[{}] with variables[{}]", new Object[]{processDefinitionKey, businessKey, variables});
        SimulationRunContext.getRuntimeService().startProcessInstanceByKey(processDefinitionKey, businessKey, variables);
    }
}

