/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.core.common.model.connector.VariableDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.runtime.api.connector.InboundVariableValueProvider;

public class InboundVariablesProvider {
    private InboundVariableValueProvider mappedValueProvider;

    public InboundVariablesProvider(InboundVariableValueProvider mappedValueProvider) {
        this.mappedValueProvider = mappedValueProvider;
    }

    public Map<String, Object> calculateVariables(DelegateExecution execution, ActionDefinition actionDefinition) {
        HashMap<String, Object> inboundVariables;
        if (actionDefinition == null) {
            inboundVariables = new HashMap<String, Object>(execution.getVariables());
        } else {
            List connectorInputs = actionDefinition.getInputs();
            inboundVariables = new HashMap();
            connectorInputs.forEach(variableDefinition -> {
                Object value = this.mappedValueProvider.calculateMappedValue((VariableDefinition)variableDefinition, execution);
                if (value != null) {
                    inboundVariables.put(variableDefinition.getName(), value);
                }
            });
        }
        inboundVariables.putAll(this.mappedValueProvider.calculateStaticValues(execution));
        return inboundVariables;
    }
}

