/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.util;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.avaje.agentloader.AgentLoader;
import sun.tools.attach.BsdVirtualMachine;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

public class EbeanAgentLoader
extends AgentLoader {
    private static final Logger log = Logger.getLogger(AgentLoader.class.getName());
    private static final List<String> loaded = new ArrayList<String>();
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public VirtualMachine attachVirtualMachine(String id) {
            return null;
        }

        @Override
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };

    private static final String discoverPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    public static void loadAgent(String jarFilePath) {
        EbeanAgentLoader.loadAgent(jarFilePath, "");
    }

    public static void loadAgent(String jarFilePath, String params) {
        log.info("dynamically loading javaagent for " + jarFilePath);
        try {
            String pid = EbeanAgentLoader.discoverPid();
            VirtualMachine vm = AttachProvider.providers().isEmpty() ? EbeanAgentLoader.getVirtualMachineImplementationFromEmbeddedOnes(pid) : VirtualMachine.attach(pid);
            vm.loadAgent(jarFilePath, params);
            vm.detach();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadAgentFromClasspath(String agentName) {
        EbeanAgentLoader.loadAgentFromClasspath(agentName, "");
    }

    public static synchronized boolean loadAgentFromClasspath(String agentName, String params) {
        if (loaded.contains(agentName)) {
            return true;
        }
        try {
            ClassLoader cl0 = AgentLoader.class.getClassLoader();
            if (!(cl0 instanceof URLClassLoader)) {
                cl0 = cl0.getParent();
            }
            if (cl0 instanceof URLClassLoader) {
                URLClassLoader cl = (URLClassLoader)cl0;
                for (URL url : cl.getURLs()) {
                    if (!EbeanAgentLoader.isMatch(url, agentName)) continue;
                    String fullName = url.toURI().getPath();
                    if (fullName.startsWith("/") && EbeanAgentLoader.isWindows()) {
                        fullName = fullName.substring(1);
                    }
                    EbeanAgentLoader.loadAgent(fullName, params);
                    loaded.add(fullName);
                    return true;
                }
            }
            return false;
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    private static boolean isMatch(URL url, String partial) {
        String fullPath = url.getFile();
        int lastSlash = fullPath.lastIndexOf(47);
        if (lastSlash < 0) {
            return false;
        }
        String jarName = fullPath.substring(lastSlash + 1);
        return jarName.startsWith(partial);
    }

    private static final boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private static VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes(String pid) {
        try {
            if (EbeanAgentLoader.isWindows()) {
                return new WindowsVirtualMachine(ATTACH_PROVIDER, pid);
            }
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
                return new LinuxVirtualMachine(ATTACH_PROVIDER, pid);
            }
            if (osName.startsWith("Mac OS X")) {
                return new BsdVirtualMachine(ATTACH_PROVIDER, pid);
            }
            if (osName.startsWith("Solaris")) {
                return new SolarisVirtualMachine(ATTACH_PROVIDER, pid);
            }
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native library for Attach API not available in this JRE", e);
        }
        return null;
    }
}

