/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.tx;

import act.asm.AnnotationVisitor;
import act.asm.ClassVisitor;
import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.asm.commons.AdviceAdapter;
import act.db.sql.tx.Transactional;
import act.db.sql.tx.TxInfo;
import act.db.sql.tx.TxScopeHelper;
import act.util.AppByteCodeEnhancer;
import org.osgl.util.S;

public class TxScopeEnhancer
extends AppByteCodeEnhancer<TxScopeEnhancer> {
    private static final String DESC_TRANSACTIONAL = Type.getDescriptor(Transactional.class);
    private static final Type TYPE_TX_INFO = Type.getType(TxInfo.class);
    private static final Type TYPE_TX_SCOPE_HELPER = Type.getType(TxScopeHelper.class);
    private String className;
    private String methodName;

    public TxScopeEnhancer() {
        super(S.F.startsWith((String)"act.").negate());
    }

    public TxScopeEnhancer(ClassVisitor cv) {
        super(S.F.startsWith((String)"act.").negate(), cv);
    }

    protected Class<TxScopeEnhancer> subClass() {
        return TxScopeEnhancer.class;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return mv;
        }
        this.methodName = name;
        return new AdviceAdapter(327680, mv, access, name, desc){
            private boolean readOnly;
            private boolean txScoped;
            private int posTxInfo;
            private Label startFinally;
            {
                this.startFinally = new Label();
            }

            public void visitCode() {
                super.visitCode();
                if (this.txScoped) {
                    this.mv.visitLabel(this.startFinally);
                }
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.txScoped) {
                    Label endFinally = new Label();
                    this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
                    this.mv.visitLabel(endFinally);
                    this.onFinally(191);
                    this.mv.visitInsn(191);
                    this.mv.visitMaxs(maxStack, maxLocals);
                } else {
                    super.visitMaxs(maxStack, maxLocals);
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (DESC_TRANSACTIONAL.equals(desc)) {
                    this.txScoped = true;
                    return new AnnotationVisitor(327680, av){

                        public void visit(String name, Object value) {
                            if ("readOnly".equals(name)) {
                                readOnly = Boolean.parseBoolean(value.toString());
                            }
                            super.visit(name, value);
                        }
                    };
                }
                return av;
            }

            protected void onMethodEnter() {
                if (!this.txScoped) {
                    return;
                }
                this.posTxInfo = this.newLocal(TYPE_TX_INFO);
                this.mv.visitTypeInsn(187, TYPE_TX_INFO.getInternalName());
                this.mv.visitInsn(89);
                this.mv.visitInsn(this.readOnly ? 4 : 3);
                this.mv.visitMethodInsn(183, TYPE_TX_INFO.getInternalName(), "<init>", "(Z)V", false);
                this.mv.visitVarInsn(58, this.posTxInfo);
                this.mv.visitVarInsn(25, this.posTxInfo);
                this.mv.visitMethodInsn(184, TYPE_TX_SCOPE_HELPER.getInternalName(), "enter", "(" + TYPE_TX_INFO.getDescriptor() + ")V", false);
            }

            protected final void onMethodExit(int opcode) {
                if (!this.txScoped) {
                    return;
                }
                if (opcode != 191) {
                    this.onFinally(opcode);
                }
            }

            private void onFinally(int opcode) {
                if (opcode == 177) {
                    this.visitInsn(1);
                } else if (opcode == 176 || opcode == 191) {
                    this.dup();
                } else {
                    if (opcode == 173 || opcode == 175) {
                        this.dup2();
                    } else {
                        this.dup();
                    }
                    this.box(Type.getReturnType((String)this.methodDesc));
                }
                this.visitIntInsn(17, opcode);
                this.visitMethodInsn(184, TYPE_TX_SCOPE_HELPER.getInternalName(), "exit", "(Ljava/lang/Object;I)V", false);
            }
        };
    }
}

