/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.inject;

import act.Act;
import act.app.App;
import act.db.sql.DataSourceProvider;
import act.db.sql.SqlDbService;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.osgl.inject.Genie;
import org.osgl.inject.NamedProvider;

public class SqlDbProviders {
    private static Provider<SqlDbService> SQL_DB_SVC_PROVIDER = new Provider<SqlDbService>(){

        public SqlDbService get() {
            return (SqlDbService)((Object)NAMED_SQL_DB_SVC_PROVIDER.get("default"));
        }
    };
    private static NamedProvider<SqlDbService> NAMED_SQL_DB_SVC_PROVIDER = new NamedProvider<SqlDbService>(){

        public SqlDbService get(String name) {
            return (SqlDbService)Act.app().dbServiceManager().dbService(name);
        }
    };
    private static Provider<DataSource> DATA_SRC_PROVIDER = new Provider<DataSource>(){

        public DataSource get() {
            return (DataSource)NAMED_DATA_SRC_PROVIDER.get("default");
        }
    };
    private static NamedProvider<DataSource> NAMED_DATA_SRC_PROVIDER = new NamedProvider<DataSource>(){

        public DataSource get(String name) {
            SqlDbService sqlDbService = (SqlDbService)((Object)NAMED_SQL_DB_SVC_PROVIDER.get(name));
            return sqlDbService.dataSource();
        }
    };
    private static Provider<DataSourceProvider> DATA_SRC_PROVIDER_PROVIDER = new Provider<DataSourceProvider>(){

        public DataSourceProvider get() {
            return (DataSourceProvider)((Object)NAMED_DATA_SRC_PROVIDER_PROVIDER.get("default"));
        }
    };
    private static NamedProvider<DataSourceProvider> NAMED_DATA_SRC_PROVIDER_PROVIDER = new NamedProvider<DataSourceProvider>(){

        public DataSourceProvider get(String name) {
            SqlDbService sqlDbService = (SqlDbService)((Object)NAMED_SQL_DB_SVC_PROVIDER.get(name));
            return sqlDbService.dataSourceProvider();
        }
    };

    public static void classInit(App app) {
        Genie genie = (Genie)app.getInstance(Genie.class);
        genie.registerProvider(SqlDbService.class, SQL_DB_SVC_PROVIDER);
        genie.registerNamedProvider(SqlDbService.class, NAMED_SQL_DB_SVC_PROVIDER);
        genie.registerProvider(DataSource.class, DATA_SRC_PROVIDER);
        genie.registerNamedProvider(DataSource.class, NAMED_DATA_SRC_PROVIDER);
        genie.registerProvider(DataSourceProvider.class, DATA_SRC_PROVIDER_PROVIDER);
        genie.registerNamedProvider(DataSourceProvider.class, NAMED_DATA_SRC_PROVIDER_PROVIDER);
    }
}

