/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.ebean;

import act.db.sql.DataSourceConfig;
import act.db.sql.SqlDbService;
import act.db.sql.SqlDbServiceConfig;
import act.db.sql.util.NamingConvention;
import com.avaje.ebean.config.MatchingNamingConvention;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.UnderscoreNamingConvention;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;
import javax.sql.DataSource;

@Singleton
public class EbeanConfigAdaptor {
    public ServerConfig adaptFrom(SqlDbServiceConfig svcConfig, SqlDbService svc) {
        ServerConfig config = new ServerConfig();
        config.setName(svc.id());
        DataSource dataSource = svc.dataSource();
        if (null == dataSource) {
            config.setDataSourceConfig(this.adaptFrom(svcConfig.dataSourceConfig, svc));
        } else {
            config.setDataSource(svc.dataSource());
        }
        config.setDdlGenerate(true);
        config.setDdlRun(true);
        config.setDdlCreateOnly(!svcConfig.ddlGeneratorConfig.drop);
        config.setNamingConvention(this.namingConvention(svcConfig));
        Set modelClasses = svc.entityClasses();
        if (null != modelClasses && !modelClasses.isEmpty()) {
            for (Class modelClass : modelClasses) {
                config.addClass(modelClass);
            }
        }
        return config;
    }

    public org.avaje.datasource.DataSourceConfig adaptFrom(DataSourceConfig actConfig, SqlDbService svc) {
        Properties properties = new Properties();
        properties.putAll(actConfig.customProperties);
        org.avaje.datasource.DataSourceConfig config = new org.avaje.datasource.DataSourceConfig();
        config.loadSettings(properties, svc.id());
        config.setUrl(actConfig.url);
        config.setDriver(actConfig.driver);
        config.setUsername(actConfig.username);
        config.setPassword(actConfig.password);
        config.setAutoCommit(actConfig.autoCommit);
        config.setMinConnections(actConfig.minConnections);
        config.setMaxConnections(actConfig.maxConnections);
        config.setIsolationLevel(actConfig.isolationLevel);
        config.setWaitTimeoutMillis(actConfig.connectionTimeout);
        return config;
    }

    private NamingConvention namingConvention(SqlDbServiceConfig svcConfig) {
        if (NamingConvention.Default.MATCHING == svcConfig.tableNamingConvention) {
            return new MatchingNamingConvention();
        }
        return new UnderscoreNamingConvention();
    }
}

