/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.datasource;

import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.monitor.DataSourceStatus;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.S;

public class HikariDataSourceProvider
extends DataSourceProvider {
    private static final Set<String> HIKARI_PROPS;
    private Set<HikariDataSource> created = new HashSet<HikariDataSource>();
    private Map<Integer, String> isolationLevelLookup = C.Map((Object[])new Object[]{0, "TRANSACTION_NONE", 1, "TRANSACTION_READ_UNCOMMITTED", 2, "TRANSACTION_READ_COMMITTED", 4, "TRANSACTION_REPEATABLE_READ", 8, "TRANSACTION_SERIALIZABLE"});

    @Override
    public DataSource createDataSource(DataSourceConfig conf) {
        Properties prop = this.forHikariCp(conf.customProperties);
        HikariConfig hc = new HikariConfig(prop);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("creating HikariCP data source ...");
            this.logger.trace("url: %s", new Object[]{conf.url});
            this.logger.trace("driver: %s", new Object[]{conf.driver});
            this.logger.trace("max conn: %s", new Object[]{conf.maxConnections});
            this.logger.trace("min conn: %s", new Object[]{conf.minConnections});
            this.logger.trace("autoCommit: %s", new Object[]{conf.autoCommit});
        }
        hc.setTransactionIsolation(this.isolationLevelLookup.get(conf.isolationLevel));
        hc.setJdbcUrl(conf.url);
        hc.setUsername(conf.username);
        hc.setPassword(conf.password);
        hc.setDriverClassName(conf.driver);
        hc.setMaximumPoolSize(conf.maxConnections);
        int minConn = conf.minConnections;
        if (minConn != 2) {
            hc.setMinimumIdle(minConn);
        }
        hc.setConnectionTimeout((long)(conf.connectionTimeout * 1000));
        hc.setAutoCommit(conf.autoCommit);
        hc.setReadOnly(conf.readOnly);
        HikariDataSource ds = new HikariDataSource(hc);
        this.created.add(ds);
        return ds;
    }

    @Override
    public Map<String, String> confKeyMapping() {
        return C.Map((Object[])new Object[]{"jdbcUrl", "url", "maximumPoolSize", "maxConnections", "minimumIdle", "minConnections", "connectionTimeout", "waitTimeout"});
    }

    @Override
    public DataSourceStatus getStatus(DataSource ds) {
        HikariDataSource hds = (HikariDataSource)$.cast((Object)ds);
        HikariPoolMXBean mbean = hds.getHikariPoolMXBean();
        return DataSourceStatus.create().activeConnections(mbean.getActiveConnections()).idleConnections(mbean.getIdleConnections()).totalConnections(mbean.getTotalConnections()).waitingThreads(mbean.getThreadsAwaitingConnection());
    }

    protected void releaseResources() {
        for (HikariDataSource ds : this.created) {
            this.release(ds);
        }
        this.created.clear();
        super.releaseResources();
    }

    private Properties forHikariCp(Map<String, String> conf) {
        Properties prop = new Properties();
        for (Map.Entry<String, String> entry : conf.entrySet()) {
            String key = S.camelCase((CharSequence)entry.getKey());
            if (!this.isHikariCpProperty(key)) continue;
            prop.put(key, entry.getValue());
        }
        return prop;
    }

    private boolean isHikariCpProperty(String key) {
        return HIKARI_PROPS.contains(key.toUpperCase(Locale.ENGLISH));
    }

    private void release(HikariDataSource ds) {
        ds.close();
    }

    static {
        Method[] methods;
        HIKARI_PROPS = new HashSet<String>();
        for (Method method : methods = HikariConfig.class.getDeclaredMethods()) {
            Class<?>[] paramTypes;
            String name;
            int modifier = method.getModifiers();
            if (Modifier.isStatic(modifier) || !Modifier.isPublic(modifier) || !(name = method.getName()).startsWith("set") || (paramTypes = method.getParameterTypes()).length != 1 || !$.isSimpleType(paramTypes[0])) continue;
            String key = name.substring(3).toUpperCase(Locale.ENGLISH);
            HIKARI_PROPS.add(key);
        }
    }
}

