/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.datasource;

import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.monitor.DataSourceStatus;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.util.C;

public class DruidDataSourceProvider
extends DataSourceProvider {
    private Set<DruidDataSource> created = new HashSet<DruidDataSource>();

    @Override
    public DataSource createDataSource(DataSourceConfig conf) {
        DruidDataSource source = new DruidDataSource();
        source.setUrl(conf.url);
        source.setUsername(conf.username);
        source.setPassword(conf.password);
        source.setDriverClassName(conf.driver);
        source.setDefaultTransactionIsolation(Integer.valueOf(conf.isolationLevel));
        source.setInitialSize(conf.minConnections);
        source.setMaxActive(conf.maxConnections);
        source.setMaxWait((long)(conf.connectionTimeout * 1000));
        source.setDefaultAutoCommit(conf.autoCommit);
        source.setDefaultReadOnly(Boolean.valueOf(conf.readOnly));
        Properties prop = new Properties();
        prop.putAll(conf.customProperties);
        source.configFromPropety(prop);
        this.created.add(source);
        return source;
    }

    @Override
    public Map<String, String> confKeyMapping() {
        return C.Map((Object[])new Object[]{"minIdle", "minConnections", "maxActive", "maxConnections", "maxWait", "waitTimeout", "validationQuery", "heartbeatSql", "maxPoolPreparedStatementPerConnectionSize", "pstmtCacheSize"});
    }

    @Override
    public DataSourceStatus getStatus(DataSource ds) {
        DruidDataSource dds = (DruidDataSource)$.cast((Object)ds);
        return DataSourceStatus.create().activeConnections(dds.getActiveCount()).idleConnections(dds.getPoolingCount()).waitingThreads(dds.getWaitThreadCount());
    }

    protected void releaseResources() {
        for (DruidDataSource ds : this.created) {
            this.release(ds);
        }
        this.created.clear();
        super.releaseResources();
    }

    private void release(DruidDataSource ds) {
        ds.close();
    }
}

