/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.datasource;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.osgl.util.E;
import org.osgl.util.IO;

public class DataSourceProxy
implements DataSource {
    private List<DataSource> workers;
    private int limit;
    private int cursor;

    public DataSourceProxy(Collection<? extends DataSource> dataSources) {
        E.illegalArgumentIf((dataSources.size() < 0 ? 1 : 0) != 0, (String)"no data source found");
        this.workers = new ArrayList<DataSource>();
        this.workers.addAll(dataSources);
        this.limit = this.workers.size();
    }

    public synchronized void clear() {
        this.limit = 0;
        this.cursor = 0;
        for (DataSource ds : this.workers) {
            if (!(ds instanceof Closeable)) continue;
            IO.close((Closeable)((Closeable)((Object)ds)));
        }
        this.workers.clear();
    }

    private synchronized DataSource getOne() {
        return this.workers.get(this.cursor);
    }

    private DataSource getOneAndMoveCursor() {
        DataSource ds = this.getOne();
        this.cursor = (this.cursor + 1) % this.limit;
        return ds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getOneAndMoveCursor().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getOneAndMoveCursor().getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getOne().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getOne().isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getOne().getLogWriter();
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        for (DataSource ds : this.workers) {
            ds.setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        for (DataSource ds : this.workers) {
            ds.setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getOne().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getOne().getParentLogger();
    }
}

