/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.conf.AppConfigKey;
import act.conf.ConfigKey;
import act.db.DbService;
import act.db.DbServiceInitialized;
import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.SqlDbServiceConfig;
import act.db.sql.datasource.DataSourceProxy;
import act.db.sql.datasource.SharedDataSourceProvider;
import act.db.sql.ddl.DDL;
import act.db.sql.monitor.DataSourceStatus;
import act.db.sql.tx.TxContext;
import act.db.sql.tx.TxInfo;
import act.db.sql.tx.TxScopeEventListener;
import act.db.sql.util.EbeanAgentLoader;
import act.event.ActEvent;
import act.event.SysEventListenerBase;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgl.Lang;
import org.osgl.OsglConfig;
import org.osgl.util.E;
import org.osgl.util.S;
import osgl.version.Version;

public abstract class SqlDbService
extends DbService {
    public static final Version VERSION = Version.of(SqlDbService.class);
    public static final DataSourceStatus DUMB_STATUS = new DataSourceStatus();
    protected SqlDbServiceConfig config;
    protected DataSource ds;
    protected DataSource dsReadOnly;
    private boolean initialized;

    public SqlDbService(final String dbId, final App app, final Map<String, String> config) {
        super(dbId, app);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SqlDbService.this.init(app, dbId, config);
            }
        };
        if (app.isDev()) {
            app.jobManager().alongWith(SysEventId.DEPENDENCY_INJECTOR_LOADED, this.jobId("init"), runnable);
        } else {
            app.jobManager().post(SysEventId.DEPENDENCY_INJECTOR_LOADED, this.jobId("init"), runnable);
        }
        if (Act.isDev() && !this.supportDdl()) {
            app.eventBus().bind(SysEventId.PRE_LOAD_CLASSES, (SysEventListener)new SysEventListenerBase(S.builder((String)dbId).append("-ebean-pre-cl")){

                public void on(EventObject event) {
                    Object o = config.get("agentPackage");
                    String agentPackage = null == o ? S.string((Object)SqlDbService.this.app().config().get((ConfigKey)AppConfigKey.SCAN_PACKAGE, null)) : S.string(o).trim();
                    String s = S.builder((String)"debug=").append(Act.isDev() ? "1" : "0").append(";packages=").append(agentPackage).toString();
                    if (!EbeanAgentLoader.loadAgentFromClasspath("ebean-agent", s)) {
                        Act.LOGGER.warn("ebean-agent not found in classpath - not dynamically loaded");
                    }
                }
            });
        }
    }

    void init(final App app, final String dbId, Map<String, String> conf) {
        if (this.isTraceEnabled()) {
            this.trace("trigger on SINGLETON_PROVISIONED event: %s", new Object[]{dbId});
        }
        try {
            final boolean traceEnabled = this.isTraceEnabled();
            if (traceEnabled) {
                this.trace("initializing %s", new Object[]{dbId});
            }
            this.config = new SqlDbServiceConfig(dbId, conf);
            this.configured();
            if (traceEnabled) {
                this.trace("configured: %s", new Object[]{dbId});
            }
            this.initDataSource();
            if (traceEnabled) {
                this.trace("data source initialized: %s", new Object[]{dbId});
            }
            if (!this.config.isSharedDatasource() && !this.supportDdl() && this.config.createDdl()) {
                app.jobManager().on(SysEventId.START, this.jobId("execute ddl"), new Runnable(){

                    @Override
                    public void run() {
                        if (traceEnabled) {
                            SqlDbService.this.trace("executing DDL: %s", new Object[]{dbId});
                        }
                        SqlDbService.this.executeDdl();
                    }
                });
            }
            this.initialized = true;
            if (traceEnabled) {
                this.trace("emitting db-svc-init event: %s", new Object[]{dbId});
            }
            app.jobManager().post(SysEventId.SINGLETON_PROVISIONED, this.jobId("raise DbServiceInitialized event"), new Runnable(){

                @Override
                public void run() {
                    app.eventBus().emit((ActEvent)new DbServiceInitialized((DbService)SqlDbService.this), new Object[0]);
                    if (traceEnabled) {
                        SqlDbService.this.trace("db-svc-init event triggered: %s", new Object[]{dbId});
                    }
                }
            }, true);
        }
        catch (RuntimeException e) {
            throw E.invalidConfiguration((Throwable)e, (String)"Error init SQL db service", (Object[])new Object[0]);
        }
    }

    public String toString() {
        S.Buffer buffer = S.buffer((String)((Object)((Object)this)).getClass().getSimpleName());
        String id = this.id();
        if (S.notBlank((String)id)) {
            buffer.append("[").append(id).append("]");
        }
        return buffer.toString();
    }

    public boolean initAsynchronously() {
        return true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public DataSource dataSource(boolean readonly) {
        return readonly ? this.dsReadOnly : this.ds;
    }

    public DataSource dataSource() {
        return this.ds;
    }

    public DataSource dataSourceReadOnly() {
        return this.dsReadOnly;
    }

    public DataSource newDataSource() {
        return this.dataSourceProvider().createDataSource(this.dataSourceConfig());
    }

    public DataSourceProvider dataSourceProvider() {
        return this.config.dataSourceProvider();
    }

    public DataSourceConfig dataSourceConfig() {
        return this.config.dataSourceConfig;
    }

    public DataSourceStatus dataSourceStatus() {
        DataSourceProvider dsp = this.dataSourceProvider();
        return null == dsp ? DUMB_STATUS : dsp.getStatus(this.ds);
    }

    protected void releaseResources() {
        DataSourceProvider dsp;
        DataSourceProvider dataSourceProvider = dsp = null == this.config ? null : this.dataSourceProvider();
        if (null != dsp) {
            try {
                dsp.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ds = null;
        if (this.dsReadOnly instanceof DataSourceProxy) {
            ((DataSourceProxy)this.dsReadOnly).clear();
        }
        this.dsReadOnly = null;
        this.config = null;
    }

    protected DataSourceProvider builtInDataSourceProvider() {
        return DataSourceProvider.NULL_PROVIDER;
    }

    protected void configured() {
    }

    private void initDataSource() {
        DataSourceProvider dsProvider;
        if (this.isTraceEnabled()) {
            this.trace("init data source: %s", new Object[]{this.id()});
        }
        if (null == (dsProvider = this.config.dataSourceProvider())) {
            dsProvider = this.builtInDataSourceProvider();
            E.unsupportedIf((null == dsProvider ? 1 : 0) != 0, (String)"%s does not support built-in datasource", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (dsProvider.initialized()) {
            this.doInitDataSource(dsProvider);
        } else {
            final DataSourceProvider finalProvider = dsProvider;
            dsProvider.setInitializationCallback((Lang.Function<DataSourceProvider, ?>)new Lang.Visitor<DataSourceProvider>(){

                public void visit(DataSourceProvider dataSourceProvider) throws Lang.Break {
                    SqlDbService.this.doInitDataSource(finalProvider);
                }
            });
        }
    }

    private void doInitDataSource(DataSourceProvider dsProvider) {
        DataSourceConfig dsConfig = this.config.dataSourceConfig;
        if (dsProvider instanceof SharedDataSourceProvider) {
            dsConfig = ((SharedDataSourceProvider)dsProvider).dataSourceConfig();
        }
        this.ds = dsProvider.createDataSource(dsConfig);
        this.dataSourceProvided(this.ds, dsConfig, false);
        this.processSlave(dsProvider, dsConfig);
    }

    private void processSlave(DataSourceProvider dsProvider, DataSourceConfig dsConfig) {
        this.dsReadOnly = this.ds;
        if (dsConfig.hasSlave()) {
            if (dsConfig.hasSoleSlave()) {
                this.dsReadOnly = dsProvider.createDataSource(dsConfig.soleSlave());
            } else {
                ArrayList<DataSource> slaves = new ArrayList<DataSource>();
                for (DataSourceConfig slaveConf : dsConfig.slaveDataSourceConfigurations) {
                    DataSource slave = dsProvider.createDataSource(slaveConf);
                    slaves.add(slave);
                }
                this.dsReadOnly = new DataSourceProxy(slaves);
            }
            this.dataSourceProvided(this.dsReadOnly, dsConfig, true);
        }
    }

    protected void dataSourceProvided(DataSource dataSource, DataSourceConfig dataSourceConfig, boolean readonly) {
    }

    protected abstract boolean supportDdl();

    public String tableNameFromClassName(String className) {
        return this.config.tableNamingConvention.toDb(className);
    }

    public String fieldNameFromPropertyName(String propertyName) {
        return this.config.fieldNamingConvention.toDb(propertyName);
    }

    protected void executeDdl() {
        Set models = this.entityClasses();
        if (models.isEmpty()) {
            return;
        }
        DDL.execute(this, this.config);
    }

    public boolean beginTxIfRequired(Object delegate) {
        TxInfo info = TxContext.info();
        if (null != info && info.withinTxScope) {
            if (null != info.listener) {
                return true;
            }
            this.doStartTx(delegate, info.readOnly);
            info.listener = this.createTxListener(delegate);
            return true;
        }
        return false;
    }

    public void forceBeginTx(Object delegate) {
        TxInfo info = TxContext.info();
        if (null != info && null != info.listener) {
            return;
        }
        if (null == info || !info.withinTxScope) {
            info = TxContext.enterTxScope(false);
        }
        E.illegalStateIf((boolean)info.readOnly, (String)"Existing TX is read only");
        this.doStartTx(delegate, false);
        info.listener = this.createTxListener(delegate);
    }

    protected abstract void doStartTx(Object var1, boolean var2);

    protected abstract void doRollbackTx(Object var1, Throwable var2);

    protected abstract void doEndTxIfActive(Object var1);

    protected TxScopeEventListener createTxListener(final Object delegate) {
        return new TxScopeEventListener(){

            @Override
            public void exit() {
                SqlDbService.this.doEndTxIfActive(delegate);
            }

            @Override
            public void rollback(Throwable throwable) {
                SqlDbService.this.doRollbackTx(delegate, throwable);
            }
        };
    }

    protected String jobId(String task) {
        return S.buffer((String)"sql_db_service[").append(this.id()).append("] - ").append(task).toString();
    }

    static {
        DriverManager.println("loading DriverManager proactively");
        OsglConfig.addGlobalMappingFilter((String)"starts:_ebean_");
    }
}

