/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql;

import act.app.App;
import act.app.event.SysEventId;
import act.db.DbPlugin;
import act.db.sql.inject.SqlDbProviders;
import act.db.sql.tx.TxContext;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.handler.event.BeforeResultCommit;
import org.osgl.util.S;

public abstract class SqlDbPlugin
extends DbPlugin {
    private static boolean registered;

    protected final void applyTo(final App app) {
        if (registered) {
            return;
        }
        registered = true;
        super.applyTo(app);
        app.jobManager().on(SysEventId.STOP, this.jobId("reset registered"), new Runnable(){

            @Override
            public void run() {
                registered = false;
            }
        });
        app.jobManager().on(SysEventId.PRE_START, this.jobId("class init and reset TxContext"), new Runnable(){

            @Override
            public void run() {
                SqlDbProviders.classInit(app);
                TxContext.reset();
            }
        });
        app.eventBus().bind(BeforeResultCommit.class, (ActEventListener)new ActEventListenerBase<BeforeResultCommit>(){

            public void on(BeforeResultCommit eventObject) {
                TxContext.clear();
            }
        });
        this.doExtendedApplyTo(app);
    }

    protected void doExtendedApplyTo(App app) {
    }

    protected String jobId(String task) {
        return S.buffer((String)((Object)((Object)this)).getClass().getName()).append(" - ").append(task).toString();
    }
}

