/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql;

import java.io.File;
import java.util.Map;

public class DdlGeneratorConfig {
    public boolean create;
    public boolean drop;

    public DdlGeneratorConfig(Map<String, String> conf) {
        String jdbcUrl = conf.get("url");
        boolean h2DbFileExists = this.h2DbFileExists(jdbcUrl);
        boolean createDefined = conf.containsKey("ddl.create");
        boolean dropDefined = conf.containsKey("ddl.drop");
        this.create = jdbcUrl.startsWith("jdbc:h2:");
        this.create = this.create || createDefined && Boolean.parseBoolean(conf.get("ddl.create"));
        this.drop = dropDefined && Boolean.parseBoolean(conf.get("ddl.drop"));
        this.create = this.create && (this.drop || !h2DbFileExists);
    }

    protected final boolean h2DbFileExists(String jdbcUrl) {
        if (jdbcUrl.startsWith("jdbc:h2:")) {
            if (jdbcUrl.contains("mem")) {
                return false;
            }
            String file = jdbcUrl.substring("jdbc:h2:".length()) + ".mv.db";
            File _file = new File(file);
            return _file.exists();
        }
        return false;
    }
}

