/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.CalendarCache;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFDate;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFInstant;
import net.snowflake.client.jdbc.internal.snowflake.common.util.TimeUtil;

public class SFTimestamp
extends SFInstant {
    private static final BigInteger LONG_MIN_VALUE_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigDecimal NANOS_IN_SECOND = BigDecimal.valueOf(1L).scaleByPowerOfTen(9);
    private final BigDecimal nanosSinceEpoch;
    private final TimeZone timeZone;
    private static final int BITS_FOR_TIMEZONE = 14;
    private static final int MASK_OF_TIMEZONE = 16383;

    public static SFTimestamp fromMilliseconds(long ms, TimeZone tz) {
        return SFTimestamp.fromNanoseconds(new BigDecimal(ms).scaleByPowerOfTen(6), tz);
    }

    public static SFTimestamp fromNanoseconds(long ns, TimeZone tz) {
        return SFTimestamp.fromNanoseconds(new BigDecimal(ns), tz);
    }

    public static SFTimestamp fromNanoseconds(BigDecimal ns, TimeZone tz) {
        return new SFTimestamp(ns, tz);
    }

    public static SFTimestamp fromNanoseconds(BigDecimal ns) {
        return new SFTimestamp(ns, SFInstant.GMT);
    }

    public static TimeZone convertTimezoneIndexToTimeZone(int timezoneIndex) {
        assert (timezoneIndex >= 0 && timezoneIndex <= 2880);
        boolean negate = (timezoneIndex -= 1440) < 0;
        timezoneIndex = Math.abs(timezoneIndex);
        int hour = timezoneIndex / 60;
        assert (hour >= 0 && hour <= 24);
        int min = timezoneIndex % 60;
        assert (min >= 0 && min <= 59);
        String tzName = String.format("GMT%s%02d:%02d", negate ? "-" : "+", hour, min);
        return TimeZone.getTimeZone(tzName);
    }

    public static SFTimestamp fromBinary(BigDecimal binary, int scale, TimeZone tz) {
        BigDecimal nanoseconds;
        if (tz != null) {
            nanoseconds = binary.scaleByPowerOfTen(9 - scale);
        } else {
            BigInteger secsWithTzOff = binary.toBigIntegerExact();
            BigInteger tzOff = secsWithTzOff.and(BigInteger.valueOf(16383L));
            BigInteger secsWoTzOff = secsWithTzOff.shiftRight(14);
            nanoseconds = new BigDecimal(secsWoTzOff).scaleByPowerOfTen(9 - scale);
            tz = SFTimestamp.convertTimezoneIndexToTimeZone(tzOff.intValue());
        }
        return SFTimestamp.fromNanoseconds(nanoseconds, tz);
    }

    public static SFTimestamp fromDate(Date date, int nanos, TimeZone tz) {
        Timestamp t = new Timestamp(date.getTime());
        t.setNanos(nanos);
        SFTimestamp res = new SFTimestamp(t, tz);
        return res;
    }

    public static SFTimestamp fromSFDate(SFDate sfd, TimeZone tz) {
        GregorianCalendar calUTC = CalendarCache.get(SFInstant.GMT, "GMT-source");
        calUTC.setTime(sfd.getDate());
        GregorianCalendar calLocal = CalendarCache.get(tz);
        calLocal.set(calUTC.get(1), calUTC.get(2), calUTC.get(5));
        calLocal.set(0, calUTC.get(0));
        return SFTimestamp.fromMilliseconds(calLocal.getTimeInMillis(), tz);
    }

    private SFTimestamp(BigDecimal nanosSinceEpoch, TimeZone tz) {
        this.nanosSinceEpoch = nanosSinceEpoch;
        this.timeZone = tz != null ? tz : SFInstant.GMT;
    }

    public SFTimestamp(Timestamp ts, TimeZone tz) {
        if (ts == null) {
            ts = new Timestamp(new Date().getTime());
        }
        this.nanosSinceEpoch = new BigDecimal(ts.getTime()).scaleByPowerOfTen(-3).setScale(0, RoundingMode.FLOOR).scaleByPowerOfTen(9).add(BigDecimal.valueOf(ts.getNanos()));
        this.timeZone = tz != null ? tz : SFInstant.GMT;
    }

    public SFTimestamp(Timestamp ts) {
        this(ts, SFInstant.GMT);
    }

    public SFTimestamp(SFDate date) {
        this(new Timestamp(date.getTime()), SFInstant.GMT);
    }

    public SFTimestamp() {
        this((Timestamp)null, null);
    }

    public SFTimestamp(SFTimestamp sft) {
        this.nanosSinceEpoch = sft.nanosSinceEpoch;
        this.timeZone = (TimeZone)sft.timeZone.clone();
    }

    public BigDecimal getNanosSinceEpoch() {
        return this.nanosSinceEpoch;
    }

    public Timestamp getTimestamp() throws TimestampOperationNotAvailableException {
        Timestamp ts = TimeUtil.timestampFromNs(this.nanosSinceEpoch);
        if (ts == null) {
            throw new TimestampOperationNotAvailableException(this);
        }
        return ts;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public SFTimestamp changeTimeZone(TimeZone timeZone) {
        return new SFTimestamp(this.nanosSinceEpoch, timeZone);
    }

    public SFTimestamp moveToTimeZone(TimeZone newTimeZone) throws TimestampOperationNotAvailableException {
        return this.moveToTimeZone(newTimeZone, false);
    }

    public SFTimestamp moveToTimeZone(TimeZone newTimeZone, boolean cCompatibility) throws TimestampOperationNotAvailableException {
        int offsetMillisInOldTZ = this.getTimeZone().getOffset(this.getTime());
        GregorianCalendar calendar = CalendarCache.get(this.getTimeZone());
        calendar.setTimeInMillis(this.getTime());
        int millisecondWithinDay = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int era = calendar.get(0);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int dayOfMonth = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        int offsetMillisInNewTZ = newTimeZone.getOffset(era, year, month, dayOfMonth, dayOfWeek, millisecondWithinDay);
        if (cCompatibility) {
            if (TimeUtil.isDSTAmbiguous(this.getTime() + (long)offsetMillisInOldTZ - (long)offsetMillisInNewTZ, newTimeZone)) {
                offsetMillisInNewTZ += newTimeZone.getDSTSavings();
            } else if (TimeUtil.isDSTIllegal(era, year, month, dayOfMonth, dayOfWeek, millisecondWithinDay, newTimeZone)) {
                offsetMillisInNewTZ -= newTimeZone.getDSTSavings();
            }
        }
        int offsetMillis = offsetMillisInOldTZ - offsetMillisInNewTZ;
        long newMillis = this.getTime() + (long)offsetMillis;
        Timestamp newSqlTs = new Timestamp(newMillis);
        newSqlTs.setNanos(this.getNanos());
        return new SFTimestamp(newSqlTs, newTimeZone);
    }

    public SFTimestamp adjustScale(int scale) {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Invalid timestamp scale " + scale);
        }
        int zeroesAtEnd = 9 - scale;
        BigDecimal powerOfTen = BigDecimal.valueOf(SFInstant.POWERS_OF_TEN[zeroesAtEnd]);
        BigDecimal extraDigits = this.nanosSinceEpoch.remainder(powerOfTen);
        if (extraDigits.equals(BigDecimal.ZERO)) {
            return this;
        }
        if (extraDigits.compareTo(BigDecimal.ZERO) < 0) {
            extraDigits = powerOfTen.add(extraDigits);
        }
        BigDecimal newNanosSinceEpoch = this.nanosSinceEpoch.subtract(extraDigits);
        return new SFTimestamp(newNanosSinceEpoch, this.getTimeZone());
    }

    public String toUTCString() {
        Timestamp timestamp = TimeUtil.timestampFromNs(this.nanosSinceEpoch);
        if (timestamp == null) {
            return "(seconds_since_epoch=" + this.nanosSinceEpoch.scaleByPowerOfTen(-9).toPlainString() + ")";
        }
        String nanoStr = String.format(".%1$09d", timestamp.getNanos());
        GregorianCalendar calendar = CalendarCache.get("UTC");
        SimpleDateFormat tsf = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss" + nanoStr + "XXX");
        tsf.setCalendar(calendar);
        String res = tsf.format(timestamp.getTime());
        return res;
    }

    public int compareTo(SFTimestamp other) {
        return this.nanosSinceEpoch.compareTo(other.nanosSinceEpoch);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SFTimestamp)) {
            return false;
        }
        return this.equals((SFTimestamp)o);
    }

    public boolean equals(SFTimestamp other) {
        return this.nanosSinceEpoch.equals(other.nanosSinceEpoch);
    }

    public long getTime() throws TimestampOperationNotAvailableException {
        BigInteger timeBigInt = this.getTimeInMsBigInt();
        if (timeBigInt.compareTo(LONG_MIN_VALUE_BIGINT) < 0 || timeBigInt.compareTo(LONG_MAX_VALUE_BIGINT) > 0) {
            throw new TimestampOperationNotAvailableException(this);
        }
        return timeBigInt.longValue();
    }

    public BigInteger getTimeInMsBigInt() {
        return this.nanosSinceEpoch.scaleByPowerOfTen(-6).setScale(0, RoundingMode.FLOOR).toBigInteger();
    }

    public BigInteger getSeconds() {
        return this.nanosSinceEpoch.scaleByPowerOfTen(-9).setScale(0, RoundingMode.FLOOR).toBigInteger();
    }

    public int getNanos() {
        BigDecimal nsFractional = this.nanosSinceEpoch.remainder(NANOS_IN_SECOND);
        if (nsFractional.compareTo(BigDecimal.ZERO) < 0) {
            nsFractional = nsFractional.add(NANOS_IN_SECOND);
        }
        return nsFractional.intValue();
    }

    public int hashCode() {
        return this.toBinary(9, false).hashCode();
    }

    public int getTimeZoneOffsetMillis() {
        BigInteger timeMs = this.getTimeInMsBigInt();
        if (timeMs.compareTo(LONG_MIN_VALUE_BIGINT) < 0 || timeMs.compareTo(LONG_MAX_VALUE_BIGINT) > 0) {
            return this.timeZone.getRawOffset();
        }
        return this.timeZone.getOffset(timeMs.longValue());
    }

    public BigInteger toBinary(int scale, boolean includeTimeZone) {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Scale must be between 0 and 9");
        }
        BigDecimal timeInNs = this.nanosSinceEpoch;
        BigDecimal scaledTime = timeInNs.scaleByPowerOfTen(scale - 9);
        scaledTime = scaledTime.setScale(0, RoundingMode.DOWN);
        BigInteger fcpInt = scaledTime.unscaledValue();
        if (includeTimeZone) {
            int offsetMillis = this.getTimeZoneOffsetMillis();
            int offsetMin = offsetMillis / 60000;
            assert (offsetMin >= -1440 && offsetMin <= 1440);
            fcpInt = fcpInt.shiftLeft(14);
            fcpInt = fcpInt.add(BigInteger.valueOf((offsetMin += 1440) & 0x3FFF));
        }
        return fcpInt;
    }

    @Override
    public int extract(int field, Integer optWeekStart, Integer optWoyPolicy) throws TimestampOperationNotAvailableException {
        TimeZone tz = this.timeZone == null ? SFInstant.GMT : this.timeZone;
        return this.extract(field, tz, this.getTime(), optWeekStart, optWoyPolicy);
    }

    public String toString() {
        String tsStr;
        try {
            tsStr = "timestamp='" + this.getTimestamp().toString() + "'";
        }
        catch (TimestampOperationNotAvailableException e) {
            tsStr = "--nanos=" + this.nanosSinceEpoch;
        }
        return "SFTimestamp(" + tsStr + " timeZone='" + this.timeZone + "')";
    }

    public static class TimestampOperationNotAvailableException
    extends RuntimeException {
        TimestampOperationNotAvailableException(SFTimestamp timestamp) {
            super("nanos=" + timestamp.nanosSinceEpoch);
        }
    }
}

