/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic.detectors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.perl.Perl5Util;

public class TextFileDetector
implements MagicDetector {
    private static Log log = LogFactory.getLog(TextFileDetector.class);

    @Override
    public String getDisplayName() {
        return "Text File Detector";
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String[] getHandledExtensions() {
        return new String[]{"txt", "text"};
    }

    @Override
    public String[] getHandledTypes() {
        return new String[]{"text/plain"};
    }

    @Override
    public String getName() {
        return "textfiledetector";
    }

    @Override
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        log.debug((Object)"processing stream data");
        Perl5Util util = new Perl5Util();
        try {
            BOMInputStream bomIn = new BOMInputStream((InputStream)new ByteArrayInputStream(data), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE});
            if (bomIn.hasBOM()) {
                return new String[]{"text/plain"};
            }
        }
        catch (IOException e) {
            log.error((Object)"TextFileDetector: error detecting byte order mark");
        }
        try {
            String s = new String(data, "UTF-8");
            if (!util.match("/[^[:ascii:][:space:]]/", s)) {
                return new String[]{"text/plain"};
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"TextFileDetector: failed to process data");
        }
        return null;
    }

    @Override
    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        log.debug((Object)"processing file data");
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            byte[] b = new byte[length];
            int n = is.read(b, offset, length);
            if (n > 0) {
                return this.process(b, offset, length, bitmask, comparator, mimeType, params);
            }
        }
        catch (IOException e) {
            log.error((Object)"TextFileDetector: error", (Throwable)e);
        }
        return null;
    }
}

