/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ServiceAssemblyStatistics {
    private String mName;
    private String mInstanceName;
    private Date mLastStartupTime;
    private Date mLastStopTime;
    private Date mLastShutdownTime;
    private Value mStartupTime = new Value();
    private Value mStopTime = new Value();
    private Value mShutdownTime = new Value();
    private boolean mSAStarted = false;
    private boolean mSAStopped = false;
    private boolean mSAShutdown = false;
    private CompositeType mServiceUnitStatsType;
    private CompositeType mServiceAssemblyStatsType;
    private Map<String, ServiceUnitStatistics> mServiceUnitStatistics = new HashMap<String, ServiceUnitStatistics>();
    public static String SA_STATISTICS_ITEM_NAME = "ServiceAssemblyStatisticsItem";
    public static String SA_STATISTICS_ITEM_DESCRIPTION = "SA statistics for an instance";
    public static String SU_STATISTICS_ITEM_NAME = "ServiceUnitStatisticsItem";
    public static String SU_STATISTICS_ITEM_DESCRIPTION = "Service unit statistics for an instance";
    public static String SERVICE_UNIT_NAME = "ServiceUnitName";
    public static String SERVICE_UNIT_STARTUP_TIME = "ServiceUnitStartupTime Avg (ms)";
    public static String SERVICE_UNIT_STOP_TIME = "ServiceUnitStopTime Avg (ms)";
    public static String SERVICE_UNIT_SHUTDOWN_TIME = "ServiceUnitShutdownTime Avg (ms)";
    public static String INSTANCE_NAME = "InstanceName";
    public static String SERVICE_ASSEMBLY_NAME = "ServiceAssemblyName";
    public static String SERVICE_ASSEMBLY_UPTIME = "UpTime (ms)";
    public static String SERVICE_ASSEMBLY_LAST_STARTUP_TIME = "LastStartupTime";
    public static final String SERVICE_ASSEMBLY_STARTUP_TIME = "StartupTime Avg (ms)";
    public static final String SERVICE_ASSEMBLY_STOP_TIME = "StopTime Avg (ms)";
    public static final String SERVICE_ASSEMBLY_SHUTDOWN_TIME = "ShutdownTime Avg (ms)";
    public static final String SERVICE_ASSEMBLY_SU_STATISTICS = "ServiceUnitStatistics";
    public static final String SERVICE_UNIT_NAME_DESCRIPTION = "Name of the service unit";
    public static final String SERVICE_UNIT_STARTUP_TIME_DESCRIPTION = "Service Unit StartupTime Avg (ms)";
    public static final String SERVICE_UNIT_STOP_TIME_DESCRIPTION = "Service Unit StopTime Avg (ms)";
    public static final String SERVICE_UNIT_SHUTDOWN_TIME_DESCRIPTION = "Service Unit ShutdownTime Avg (ms)";
    public static final String JBI_INSTANCE_NAME_DESCRIPTION = "JBI Instance Name";
    public static final String SERVICE_ASSEMBLY_NAME_DESCRIPTION = "Service Assembly Name";
    public static final String SERVICE_ASSEMBLY_UPTIME_DESCRIPTION = "Uptime of service assembly in ms.";
    public static final String SERVICE_ASSEMBLY_LAST_STARTUP_TIME_DESCRIPTION = "Last Startup Time";
    public static final String SERVICE_ASSEMBLY_STARTUP_TIME_DESCRIPTION = "Startup Time Avg (ms)";
    public static final String SERVICE_ASSEMBLY_STOP_TIME_DESCRIPTION = "Stop Time Avg (ms)";
    public static final String SERVICE_ASSEMBLY_SHUTDOWN_TIME_DESCTIPTION = "Shutdown Time Avg (ms)";
    public static final String SERVICE_ASSEMBLY_SU_STATISTICS_DESCRIPTION = "ServiceUnit Statistics";

    ServiceAssemblyStatistics(String saName, String instanceName) throws Exception {
        this.mName = saName;
        this.mInstanceName = instanceName;
    }

    public Date getLastStartupTime() {
        return this.mLastStartupTime;
    }

    public Date getLastStopTime() {
        return this.mLastStopTime;
    }

    public Date getLastShutdownTime() {
        return this.mLastShutdownTime;
    }

    public Value getStartupTime() {
        return this.mStartupTime;
    }

    public Value getStopTime() {
        return this.mStopTime;
    }

    public Value getShutdownTime() {
        return this.mShutdownTime;
    }

    public String getName() {
        return this.mName;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public void setServiceUnitList(Map<String, ServiceUnitStatistics> serviceUnitStats) {
        this.mServiceUnitStatistics = serviceUnitStats;
    }

    public void updateStartupStatistics(Date beginTime, Date endTime, Map<String, Long> suTimes) {
        this.mSAStarted = true;
        this.mLastStartupTime = endTime;
        this.mStartupTime.addSample(endTime.getTime() - beginTime.getTime());
        Set<String> serviceUnits = this.mServiceUnitStatistics.keySet();
        for (String su : serviceUnits) {
            if (!suTimes.containsKey(su)) continue;
            this.mServiceUnitStatistics.get(su).updateStartupStatistics(suTimes.get(su));
        }
    }

    public void updateStopStatistics(Date beginTime, Date endTime, Map<String, Long> suTimes) {
        this.mSAStopped = true;
        this.mLastStopTime = endTime;
        this.mStopTime.addSample(endTime.getTime() - beginTime.getTime());
        Set<String> serviceUnits = this.mServiceUnitStatistics.keySet();
        for (String su : serviceUnits) {
            if (!suTimes.containsKey(su)) continue;
            this.mServiceUnitStatistics.get(su).updateStopStatistics(suTimes.get(su));
        }
    }

    public void updateShutdownStatistics(Date beginTime, Date endTime, Map<String, Long> suTimes) {
        this.mSAShutdown = true;
        this.mLastShutdownTime = endTime;
        this.mShutdownTime.addSample(endTime.getTime() - beginTime.getTime());
        Set<String> serviceUnits = this.mServiceUnitStatistics.keySet();
        for (String su : serviceUnits) {
            if (!suTimes.containsKey(su)) continue;
            this.mServiceUnitStatistics.get(su).updateShutdownStatistics(suTimes.get(su));
        }
    }

    public CompositeData getCompositeData() throws OpenDataException {
        Set<String> serviceUnits = this.mServiceUnitStatistics.keySet();
        CompositeData[] serviceUnitStats = new CompositeData[serviceUnits.size()];
        CompositeType serviceUnitStatsCompositeType = null;
        int i = 0;
        for (String su : serviceUnits) {
            CompositeData cData = this.mServiceUnitStatistics.get(su).getCompositeData();
            serviceUnitStats[i++] = cData;
            serviceUnitStatsCompositeType = cData.getCompositeType();
        }
        long upTime = 0L;
        if (this.getLastStartupTime() != null) {
            upTime = System.currentTimeMillis() - this.getLastStartupTime().getTime();
        }
        ArrayList<String> saStatsItemNames = new ArrayList<String>();
        ArrayList<String> saStatsItemDescriptions = new ArrayList<String>();
        ArrayList<OpenType> saStatsItemTypes = new ArrayList<OpenType>();
        ArrayList<Object> saStatsItemValues = new ArrayList<Object>();
        saStatsItemNames.add(INSTANCE_NAME);
        saStatsItemNames.add(SERVICE_ASSEMBLY_NAME);
        saStatsItemDescriptions.add(JBI_INSTANCE_NAME_DESCRIPTION);
        saStatsItemDescriptions.add(SERVICE_ASSEMBLY_NAME_DESCRIPTION);
        saStatsItemTypes.add(SimpleType.STRING);
        saStatsItemTypes.add(SimpleType.STRING);
        saStatsItemValues.add(this.getInstanceName());
        saStatsItemValues.add(this.getName());
        if (this.mSAStarted) {
            saStatsItemNames.add(SERVICE_ASSEMBLY_UPTIME);
            saStatsItemNames.add(SERVICE_ASSEMBLY_LAST_STARTUP_TIME);
            saStatsItemNames.add(SERVICE_ASSEMBLY_STARTUP_TIME);
            saStatsItemDescriptions.add(SERVICE_ASSEMBLY_UPTIME_DESCRIPTION);
            saStatsItemDescriptions.add(SERVICE_ASSEMBLY_LAST_STARTUP_TIME_DESCRIPTION);
            saStatsItemDescriptions.add(SERVICE_ASSEMBLY_STARTUP_TIME_DESCRIPTION);
            saStatsItemTypes.add(SimpleType.LONG);
            saStatsItemTypes.add(SimpleType.DATE);
            saStatsItemTypes.add(SimpleType.LONG);
            saStatsItemValues.add(upTime);
            saStatsItemValues.add(this.getLastStartupTime());
            saStatsItemValues.add((long)this.getStartupTime().getAverage());
        }
        if (this.mSAStopped) {
            saStatsItemNames.add(SERVICE_ASSEMBLY_STOP_TIME);
            saStatsItemDescriptions.add(SERVICE_ASSEMBLY_STOP_TIME_DESCRIPTION);
            saStatsItemTypes.add(SimpleType.LONG);
            saStatsItemValues.add((long)this.getStopTime().getAverage());
        }
        if (this.mSAShutdown) {
            saStatsItemNames.add(SERVICE_ASSEMBLY_SHUTDOWN_TIME);
            saStatsItemDescriptions.add(SERVICE_ASSEMBLY_SHUTDOWN_TIME_DESCTIPTION);
            saStatsItemTypes.add(SimpleType.LONG);
            saStatsItemValues.add((long)this.getShutdownTime().getAverage());
        }
        if (serviceUnitStats != null && serviceUnitStatsCompositeType != null) {
            saStatsItemNames.add(SERVICE_ASSEMBLY_SU_STATISTICS);
            saStatsItemDescriptions.add(SERVICE_ASSEMBLY_SU_STATISTICS_DESCRIPTION);
            saStatsItemTypes.add(new ArrayType(1, serviceUnitStatsCompositeType));
            saStatsItemValues.add(serviceUnitStats);
        }
        return new CompositeDataSupport(new CompositeType(SU_STATISTICS_ITEM_NAME, SU_STATISTICS_ITEM_DESCRIPTION, saStatsItemNames.toArray(new String[0]), saStatsItemDescriptions.toArray(new String[0]), saStatsItemTypes.toArray(new OpenType[0])), saStatsItemNames.toArray(new String[0]), saStatsItemValues.toArray(new Object[0]));
    }

    class Value {
        private double sum;
        private double squaredsum;
        private long min;
        private long max;
        private long count;

        Value() {
        }

        public void zero() {
            this.sum = 0.0;
            this.squaredsum = 0.0;
            this.min = 0L;
            this.max = 0L;
            this.count = 0L;
        }

        public void addSample(long sample) {
            if (sample < this.min || this.count == 0L) {
                this.min = sample;
            }
            if (sample > this.max || this.count == 0L) {
                this.max = sample;
            }
            ++this.count;
            this.sum += (double)sample;
            this.squaredsum += (double)sample * (double)sample;
        }

        public double getAverage() {
            return this.sum / (double)this.count;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Count(" + this.count + ")");
            sb.append("Min(" + this.min + ")");
            sb.append("Avg(" + this.getAverage() + ")");
            sb.append("Max(" + this.max + ")");
            return sb.toString();
        }
    }

    class ServiceUnitStatistics {
        private String mName;
        private Value mStartupTime;
        private Value mStopTime;
        private Value mShutdownTime;
        private List mEndpoints;
        private boolean mServiceUnitStarted;
        private boolean mServiceUnitStopped;
        private boolean mServiceUnitShutdown;

        ServiceUnitStatistics(String suName) {
            this.mStartupTime = new Value();
            this.mStopTime = new Value();
            this.mShutdownTime = new Value();
            this.mEndpoints = new ArrayList();
            this.mServiceUnitStarted = false;
            this.mServiceUnitStopped = false;
            this.mServiceUnitShutdown = false;
            this.mName = suName;
        }

        public Value getStartupTime() {
            return this.mStartupTime;
        }

        public Value getStopTime() {
            return this.mStopTime;
        }

        public Value getShutdownTime() {
            return this.mShutdownTime;
        }

        public String getName() {
            return this.mName;
        }

        public void setEndpointsList(List<String> endpoints) {
            this.mEndpoints = endpoints;
        }

        public List<String> getEndpointsList() {
            return this.mEndpoints;
        }

        public void updateStartupStatistics(Long startupTime) {
            this.mServiceUnitStarted = true;
            this.mStartupTime.addSample(startupTime);
        }

        public void updateStopStatistics(Long stopTime) {
            this.mServiceUnitStopped = true;
            this.mStopTime.addSample(stopTime);
        }

        public void updateShutdownStatistics(Long shutdownTime) {
            this.mServiceUnitShutdown = true;
            this.mShutdownTime.addSample(shutdownTime);
        }

        public CompositeData getCompositeData() throws OpenDataException {
            ArrayList<String> suStatsItemNames = new ArrayList<String>();
            ArrayList<String> suStatsItemDescriptions = new ArrayList<String>();
            ArrayList<SimpleType<Object>> suStatsItemTypes = new ArrayList<SimpleType<Object>>();
            ArrayList<Object> suStatsItemValues = new ArrayList<Object>();
            suStatsItemNames.add(SERVICE_UNIT_NAME);
            suStatsItemDescriptions.add(ServiceAssemblyStatistics.SERVICE_UNIT_NAME_DESCRIPTION);
            suStatsItemTypes.add(SimpleType.STRING);
            suStatsItemValues.add(this.getName());
            if (this.mServiceUnitStarted) {
                suStatsItemNames.add(SERVICE_UNIT_STARTUP_TIME);
                suStatsItemDescriptions.add(ServiceAssemblyStatistics.SERVICE_UNIT_STARTUP_TIME_DESCRIPTION);
                suStatsItemTypes.add(SimpleType.LONG);
                suStatsItemValues.add((long)this.getStartupTime().getAverage());
            }
            if (this.mServiceUnitStopped) {
                suStatsItemNames.add(SERVICE_UNIT_STOP_TIME);
                suStatsItemDescriptions.add(ServiceAssemblyStatistics.SERVICE_UNIT_STOP_TIME_DESCRIPTION);
                suStatsItemTypes.add(SimpleType.LONG);
                suStatsItemValues.add((long)this.getStopTime().getAverage());
            }
            if (this.mServiceUnitShutdown) {
                suStatsItemNames.add(SERVICE_UNIT_SHUTDOWN_TIME);
                suStatsItemDescriptions.add(ServiceAssemblyStatistics.SERVICE_UNIT_SHUTDOWN_TIME_DESCRIPTION);
                suStatsItemTypes.add(SimpleType.LONG);
                suStatsItemValues.add((long)this.getShutdownTime().getAverage());
            }
            return new CompositeDataSupport(new CompositeType(SU_STATISTICS_ITEM_NAME, SU_STATISTICS_ITEM_DESCRIPTION, suStatsItemNames.toArray(new String[0]), suStatsItemDescriptions.toArray(new String[0]), suStatsItemTypes.toArray(new OpenType[0])), suStatsItemNames.toArray(new String[0]), suStatsItemValues.toArray(new Object[0]));
        }
    }
}

