/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.LoggingServiceMBean;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ModelSystemService;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class LoggingService
extends ModelSystemService
implements LoggingServiceMBean {
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("LoggingService");
    private ManagementContext mContext = null;
    private BuildManagementMessageImpl mMMImpl = null;

    public LoggingService(ManagementContext anEnv) {
        this.mContext = anEnv;
        this.initModelSystemService(anEnv.getEnvironmentContext());
        LoggingService loggingService = this;
        this.mMMImpl = loggingService.mContext.getManagementMessageObject();
    }

    protected void initModelSystemService(EnvironmentContext anEnv) {
        String loggerName = "com.sun.jbi.management.LoggingService";
        Logger logger = Logger.getLogger(loggerName);
        super.initModelSystemService(anEnv, logger, this.mJbiNameInfo);
        this.mStartMBeans.add(this.mLoggingServiceMBeanName, LoggingServiceMBean.class, this);
    }

    @Override
    public ObjectName getSystemLoggerMBean(String aSvcName) {
        LoggingService loggingService = this;
        MBeanNames mbn = loggingService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ServiceName" + "=" + aSvcName;
        tmp = tmp + "," + "ControlType" + "=" + "Logger";
        tmp = tmp + "," + "ComponentType" + "=" + "System";
        ObjectName[] names = this.queryHelper(tmp = tmp + ",*");
        if (names.length >= 1) {
            if (names.length > 1) {
                String statusMsg = this.mTranslator.getString("LS_GETSYSTEMLOGGERMBEAN_TOO_MANY_MBEANS", (Object)tmp);
                this.mLogger.severe(statusMsg);
            }
            return names[0];
        }
        String statusMsg = this.mTranslator.getString("LS_GETSYSTEMLOGGERMBEAN_LOOKUP_FAILED", (Object)tmp);
        this.mLogger.warning(statusMsg);
        return null;
    }

    @Override
    public ObjectName[] getSystemLoggerMBeans() {
        LoggingService loggingService = this;
        MBeanNames mbn = loggingService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentType" + "=" + "System";
        tmp = tmp + "," + "ControlType" + "=" + "Logger";
        ObjectName[] names = this.queryHelper(tmp = tmp + ",*");
        if (names.length <= 1) {
            String statusMsg = this.mTranslator.getString("LS_GETSYSTEMLOGGERMBEANS_NO_SERVICES");
            this.mLogger.severe(statusMsg);
            return new ObjectName[0];
        }
        return names;
    }

    @Override
    public ObjectName getComponentLoggerMBeanById(String aComponentId) {
        LoggingService loggingService = this;
        MBeanNames mbn = loggingService.mContext.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentName" + "=" + aComponentId;
        tmp = tmp + "," + "ComponentType" + "=" + "Installed";
        tmp = tmp + "," + "ControlType" + "=" + "Logger";
        ObjectName[] names = this.queryHelper(tmp = tmp + ",*");
        if (names.length >= 1) {
            if (names.length > 1) {
                String statusMsg = this.mTranslator.getString("LS_GETCOMPONENTLOGGERMBEANBYID_TOO_MANY_MBEANS", (Object)tmp);
                this.mLogger.severe(statusMsg);
            }
            return names[0];
        }
        String statusMsg = this.mTranslator.getString("LS_GETCOMPONENTLOGGERMBEANBYID_LOOKUP_FAILED", (Object)tmp);
        this.mLogger.warning(statusMsg);
        return null;
    }

    private ObjectName[] queryHelper(String qStr) {
        LoggingService loggingService = this;
        return loggingService.mContext.getAdminServiceHandle().queryHelper(qStr);
    }
}

