/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.config.GlobalConfiguration;
import com.sun.jbi.management.config.InstanceConfiguration;
import com.sun.jbi.management.config.RuntimeConfiguration;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.system.ConfigurationServiceMBean;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ModelSystemService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;

public class ConfigurationService
extends ModelSystemService
implements ConfigurationServiceMBean,
ServiceLifecycle {
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("ConfigurationService");
    private EnvironmentContext mEnv = null;
    private static final String DEFAULT_CONFIG_FILE = "runtime-config.defaults";
    private Set<MBeanNames.ServiceType> mConfigSvcTypes;

    protected void initModelSystemService(EnvironmentContext anEnv) throws JBIException {
        String loggerName = "com.sun.jbi.management.ConfigurationService";
        Logger logger = Logger.getLogger(loggerName);
        super.initModelSystemService(anEnv, logger, this.mJbiNameInfo);
        this.mStartMBeans.add(this.mConfigServiceMBeanName, ConfigurationServiceMBean.class, this);
    }

    public void initService(EnvironmentContext aContext) throws JBIException {
        this.mEnv = aContext;
        this.initModelSystemService(this.mEnv);
        try {
            this.registerGlobalRuntimeConfigMBeans();
            this.registerRuntimeConfigMBeans();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        this.bootstrap();
    }

    public void startService() throws JBIException {
    }

    public void stopService() throws JBIException {
        try {
            this.unregisterRuntimeConfigMBeans();
            this.unregisterGlobalRuntimeConfigMBeans();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public ObjectName[] getSystemConfigMBean(String aSvcType) {
        MBeanNames mbn = this.mEnv.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ServiceName" + "=" + "ConfigurationService";
        tmp = tmp + "," + "ControlType" + "=" + aSvcType;
        tmp = tmp + "," + "ComponentType" + "=" + "System";
        tmp = tmp + ",*";
        ObjectName[] names = null;
        try {
            ObjectName configMBeanFilter = new ObjectName(tmp);
            Set<ObjectName> nameSet = this.mMBeanServer.queryNames(configMBeanFilter, null);
            names = new ObjectName[nameSet.size()];
            nameSet.toArray(names);
        }
        catch (MalformedObjectNameException mbex) {
            this.mLogger.warning(mbex.toString());
        }
        return names;
    }

    @Override
    public ObjectName[] getSystemConfigMBeans() {
        MBeanNames mbn = this.mEnv.getMBeanNames();
        String tmp = mbn.getJmxDomainName();
        tmp = tmp + ":" + "ComponentType" + "=" + "System";
        tmp = tmp + "," + "ServiceName" + "=" + "ConfigurationService";
        tmp = tmp + ",*";
        ObjectName[] names = null;
        try {
            ObjectName configMBeanFilter = new ObjectName(tmp);
            Set<ObjectName> nameSet = this.mMBeanServer.queryNames(configMBeanFilter, null);
            names = new ObjectName[nameSet.size()];
            nameSet.toArray(names);
        }
        catch (MalformedObjectNameException mbex) {
            this.mLogger.warning(mbex.toString());
        }
        if (names.length <= 1) {
            String statusMsg = this.mTranslator.getString("CS_GETSYSTEMCONFIGMBEANS_NO_SERVICES");
            this.mLogger.severe(statusMsg);
        }
        return names;
    }

    private void registerRuntimeConfigMBeans() throws Exception {
        Map<MBeanNames.ServiceType, ConfigurationFactory> configs = ConfigurationBuilder.createConfigurations(this.readDefaultProperties());
        this.mConfigSvcTypes = configs.keySet();
        for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
            ObjectName name = this.mEnv.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(serviceType));
            if (this.mMBeanServer.isRegistered(name)) continue;
            ModelMBeanInfo mbeanInfo = RuntimeConfiguration.createMBeanInfo(configs.get(serviceType).createMBeanAttributeInfo());
            InstanceConfiguration modelConfigMBean = new InstanceConfiguration(mbeanInfo, ConfigurationCategory.valueOf((String)serviceType.toString()));
            modelConfigMBean.setManagedResource(modelConfigMBean, "ObjectReference");
            this.mMBeanServer.registerMBean(modelConfigMBean, name);
        }
    }

    private void unregisterRuntimeConfigMBeans() throws Exception {
        for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
            ObjectName name = this.mEnv.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(serviceType));
            if (!this.mMBeanServer.isRegistered(name)) continue;
            this.mMBeanServer.unregisterMBean(name);
        }
    }

    private void registerGlobalRuntimeConfigMBeans() throws Exception {
        Map<MBeanNames.ServiceType, ConfigurationFactory> configs = ConfigurationBuilder.createConfigurations(this.readDefaultProperties());
        this.mConfigSvcTypes = configs.keySet();
        ManagementContext mgtCtx = new ManagementContext(this.mEnv);
        for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
            ObjectName name = mgtCtx.getMBeanNames("domain").getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(serviceType));
            if (this.mMBeanServer.isRegistered(name)) continue;
            ModelMBeanInfo mbeanInfo = RuntimeConfiguration.createMBeanInfo(configs.get(serviceType).createMBeanAttributeInfo());
            GlobalConfiguration modelConfigMBean = new GlobalConfiguration(mbeanInfo, ConfigurationCategory.valueOf((String)serviceType.toString()));
            modelConfigMBean.setManagedResource(modelConfigMBean, "ObjectReference");
            this.mMBeanServer.registerMBean(modelConfigMBean, name);
        }
    }

    private void unregisterGlobalRuntimeConfigMBeans() throws Exception {
        ManagementContext mgtCtx = new ManagementContext(this.mEnv);
        for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
            ObjectName name = mgtCtx.getMBeanNames("domain").getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(serviceType));
            if (!this.mMBeanServer.isRegistered(name)) continue;
            this.mMBeanServer.unregisterMBean(name);
        }
    }

    private Properties readDefaultProperties() throws IOException {
        FileInputStream ipStr;
        Properties defaults = new Properties();
        StringBuffer pathToConfig = new StringBuffer(this.mEnv.getJbiInstallRoot());
        pathToConfig.append(File.separatorChar);
        pathToConfig.append("lib");
        pathToConfig.append(File.separatorChar);
        pathToConfig.append("install");
        pathToConfig.append(File.separatorChar);
        pathToConfig.append("templates");
        pathToConfig.append(File.separatorChar);
        File defConfig = new File(pathToConfig.toString(), DEFAULT_CONFIG_FILE);
        if (defConfig.exists() && defConfig.length() > 0L && (ipStr = new FileInputStream(defConfig)) != null) {
            defaults.load(ipStr);
            ((InputStream)ipStr).close();
        }
        return defaults;
    }
}

