/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.repository;

public class ArchiveType {
    private static final String BINDING = "binding-component";
    private static final String ENGINE = "service-engine";
    public static final ArchiveType COMPONENT = new ArchiveType("COMPONENT");
    public static final ArchiveType SHARED_LIBRARY = new ArchiveType("SHARED-LIBRARY");
    public static final ArchiveType SERVICE_ASSEMBLY = new ArchiveType("SERVICE-ASSEMBLY");
    public static final ArchiveType SERVICE_UNIT = new ArchiveType("SERVICE-UNIT");
    private String mType;

    private ArchiveType(String type) {
        this.mType = type;
    }

    public String toString() {
        return this.mType;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ArchiveType && ((ArchiveType)obj).mType.equals(this.mType)) {
            isEqual = true;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.mType.hashCode();
    }

    public static ArchiveType valueOf(String jbiType) {
        ArchiveType aType;
        if (jbiType.equalsIgnoreCase(BINDING)) {
            aType = COMPONENT;
        } else if (jbiType.equalsIgnoreCase(ENGINE)) {
            aType = COMPONENT;
        } else if (jbiType.equalsIgnoreCase(ArchiveType.SHARED_LIBRARY.mType)) {
            aType = SHARED_LIBRARY;
        } else if (jbiType.equalsIgnoreCase(ArchiveType.SERVICE_ASSEMBLY.mType)) {
            aType = SERVICE_ASSEMBLY;
        } else if (jbiType.equalsIgnoreCase(ArchiveType.SERVICE_UNIT.mType)) {
            aType = SERVICE_UNIT;
        } else {
            throw new IllegalArgumentException(jbiType);
        }
        return aType;
    }
}

