/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.management.ComponentInfo;
import com.sun.jbi.management.ConfigurationCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RegistryDocument {
    private Document mRegistryDocument;
    private static final String DOMAIN = "domain";

    public RegistryDocument(Document regDoc) {
        this.mRegistryDocument = regDoc;
    }

    public String getConfigurationAttribute(String target, ConfigurationCategory category, String attrName) {
        String value = null;
        value = this.isAttributeOverriden(target, category, attrName) ? this.getAttribute(target, category, attrName) : this.getAttribute(DOMAIN, category, attrName);
        return value;
    }

    public Map<String, String> getConfigurationAttributes(String target, ConfigurationCategory category) {
        Map<String, String> targetSpecificProps = this.getProperties(target, category);
        return targetSpecificProps;
    }

    public Properties getComponentConfigurationAttributes(String target, boolean isServer, String componentName) {
        Element targetElement = this.getTarget(target, isServer);
        Element compRef = this.getComponentRef(targetElement, componentName);
        return this.getComponentConfigurationProperties(compRef);
    }

    public ComponentInfo.Variable[] getComponentApplicationVariables(String target, boolean isServer, String componentName) {
        Element targetElement = this.getTarget(target, isServer);
        Element compRef = this.getComponentRef(targetElement, componentName);
        return this.getComponentApplicationVariables(compRef);
    }

    public Map<String, Properties> getComponentApplicationConfiguration(String target, boolean isServer, String componentName) {
        Element targetElement = this.getTarget(target, isServer);
        Element compRef = this.getComponentRef(targetElement, componentName);
        return this.getComponentApplicationConfigurations(compRef);
    }

    private boolean isAttributeOverriden(String target, ConfigurationCategory category, String attribName) {
        return this.getConfig(target) != null;
    }

    public String getAttribute(String target, ConfigurationCategory category, String attribName) {
        String value = null;
        Map<String, String> properties = this.getProperties(target, category);
        if (properties.containsKey(attribName)) {
            value = properties.get(attribName);
        }
        return value;
    }

    private Map<String, String> getProperties(String target, ConfigurationCategory category) {
        Object nameList = null;
        Object valueList = null;
        Properties properties = new Properties();
        Element targetConfig = this.getConfig(target);
        if (targetConfig != null) {
            NodeList configTypeList = targetConfig.getElementsByTagName("config-type");
            for (int i = 0; i < configTypeList.getLength(); ++i) {
                Element configTypeElem = (Element)configTypeList.item(i);
                if (!category.toString().equals(configTypeElem.getAttribute("category"))) continue;
                properties = this.getProperties(configTypeElem);
            }
        }
        return properties;
    }

    private Element getConfig(String target) {
        Element targetConfig = null;
        if (this.mRegistryDocument != null) {
            NodeList configs;
            Element jbi = this.mRegistryDocument.getDocumentElement();
            Element configsElem = null;
            if (jbi != null && (configs = jbi.getElementsByTagName("configs")).getLength() >= 1) {
                configsElem = (Element)configs.item(0);
            }
            if (configsElem != null) {
                NodeList configList = configsElem.getElementsByTagName("config");
                for (int i = 0; i < configList.getLength(); ++i) {
                    Element configElem = (Element)configList.item(i);
                    if (!(target + "-config").equals(configElem.getAttribute("name"))) continue;
                    targetConfig = configElem;
                }
            }
        }
        return targetConfig;
    }

    private Properties getComponentConfigurationProperties(Element compRef) {
        Properties properties = new Properties();
        if (compRef != null) {
            NodeList componentConfigs = compRef.getElementsByTagName("component-config");
            Element componentCfgElem = null;
            if (componentConfigs.getLength() >= 1) {
                componentCfgElem = (Element)componentConfigs.item(0);
            }
            if (componentCfgElem != null) {
                NodeList propertyList = componentCfgElem.getElementsByTagName("property");
                for (int j = 0; j < propertyList.getLength(); ++j) {
                    Element propertyElem = (Element)propertyList.item(j);
                    Element nameElem = (Element)propertyElem.getElementsByTagName("name").item(0);
                    String name = ((Text)nameElem.getFirstChild()).getNodeValue();
                    Element valueElem = (Element)propertyElem.getElementsByTagName("value").item(0);
                    String value = ((Text)valueElem.getFirstChild()).getNodeValue();
                    properties.put(name, value);
                }
            }
        }
        return properties;
    }

    ComponentInfo.Variable[] getComponentApplicationVariables(Element compRef) {
        ComponentInfo.Variable[] appVars = new ComponentInfo.Variable[]{};
        if (compRef != null) {
            NodeList componentConfigs = compRef.getElementsByTagName("component-config");
            Element componentCfgElem = null;
            if (componentConfigs.getLength() >= 1) {
                componentCfgElem = (Element)componentConfigs.item(0);
            }
            if (componentCfgElem != null) {
                NodeList varList = componentCfgElem.getElementsByTagName("application-variable");
                appVars = new ComponentInfo.Variable[varList.getLength()];
                for (int j = 0; j < varList.getLength(); ++j) {
                    Element varElem = (Element)varList.item(j);
                    Element nameElem = (Element)varElem.getElementsByTagName("name").item(0);
                    String name = ((Text)nameElem.getFirstChild()).getNodeValue();
                    Element valueElem = (Element)varElem.getElementsByTagName("value").item(0);
                    String value = ((Text)valueElem.getFirstChild()).getNodeValue();
                    Element typeElem = (Element)varElem.getElementsByTagName("type").item(0);
                    String type = ((Text)typeElem.getFirstChild()).getNodeValue();
                    appVars[j] = value != null && value.compareTo("null") == 0 ? new ComponentInfo.Variable(name, null, type) : new ComponentInfo.Variable(name, value, type);
                }
            }
        }
        return appVars;
    }

    Map<String, Properties> getComponentApplicationConfigurations(Element compRef) {
        HashMap<String, Properties> configMap = new HashMap<String, Properties>();
        if (compRef != null) {
            NodeList componentConfigs = compRef.getElementsByTagName("component-config");
            Element componentCfgElem = null;
            if (componentConfigs.getLength() >= 1) {
                componentCfgElem = (Element)componentConfigs.item(0);
            }
            if (componentCfgElem != null) {
                NodeList configList = componentCfgElem.getElementsByTagName("application-configuration");
                for (int j = 0; j < configList.getLength(); ++j) {
                    Element configElem = (Element)configList.item(j);
                    String configName = configElem.getAttribute("name");
                    Properties props = this.getProperties(configElem);
                    configMap.put(configName, props);
                }
            }
        }
        return configMap;
    }

    private Element getComponentRef(Element targetElement, String compName) {
        Element compRef = null;
        if (targetElement != null) {
            NodeList componentRefsList = targetElement.getElementsByTagName("component-ref");
            for (int i = 0; i < componentRefsList.getLength(); ++i) {
                Element componentElem = (Element)componentRefsList.item(i);
                if (!compName.equals(componentElem.getAttribute("name-ref"))) continue;
                compRef = componentElem;
            }
        }
        return compRef;
    }

    public Element getTarget(String target, boolean isServer) {
        Element targetRef = null;
        if (this.mRegistryDocument != null) {
            Element jbi = this.mRegistryDocument.getDocumentElement();
            Element targetsElem = null;
            if (jbi != null) {
                NodeList targets = null;
                targets = isServer ? jbi.getElementsByTagName("servers") : jbi.getElementsByTagName("clusters");
                if (targets.getLength() >= 1) {
                    targetsElem = (Element)targets.item(0);
                }
            }
            if (targetsElem != null) {
                NodeList targetList = null;
                targetList = isServer ? targetsElem.getElementsByTagName("server") : targetsElem.getElementsByTagName("cluster");
                for (int i = 0; i < targetList.getLength(); ++i) {
                    Element targetElem = (Element)targetList.item(i);
                    if (!target.equals(targetElem.getAttribute("name-ref"))) continue;
                    targetRef = targetElem;
                    break;
                }
            }
        }
        return targetRef;
    }

    Properties getProperties(Element element) {
        Properties properties = new Properties();
        NodeList propertyList = element.getElementsByTagName("property");
        for (int j = 0; j < propertyList.getLength(); ++j) {
            Element propertyElem = (Element)propertyList.item(j);
            Element nameElem = (Element)propertyElem.getElementsByTagName("name").item(0);
            String name = ((Text)nameElem.getFirstChild()).getNodeValue();
            Element valueElem = (Element)propertyElem.getElementsByTagName("value").item(0);
            String value = ((Text)valueElem.getFirstChild()).getNodeValue();
            properties.put(name, value);
        }
        return properties;
    }
}

