/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ComponentMessageHolder;
import com.sun.jbi.management.message.ComponentInstanceResult;
import com.sun.jbi.management.message.ComponentTaskResult;
import com.sun.jbi.management.message.ExceptionInfo;
import com.sun.jbi.management.message.FrmwkTaskResult;
import com.sun.jbi.management.message.FrmwkTaskResultDetails;
import com.sun.jbi.management.message.JbiTask;
import com.sun.jbi.management.message.JbiTaskResult;
import com.sun.jbi.management.message.JbiTaskResultElement;
import com.sun.jbi.management.message.MsgLocInfo;
import com.sun.jbi.management.message.ObjectFactory;
import com.sun.jbi.management.message.TaskResultDetails;
import com.sun.jbi.management.message.TaskResultDetailsElement;
import com.sun.jbi.management.message.TaskStatusMsg;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class MessageBuilder {
    private static SAXParser sXmlParser;
    private ObjectFactory mObjFactory;
    private Marshaller mWriter;
    private Unmarshaller mReader;
    private JAXBContext mJaxbContext;
    private StringTranslator mTranslator;
    private StringTranslator mLocalTranslator;
    private Logger mLog;
    private static final String TOKEN_PREFIX = "JBI";
    private static final String JBIMA0000 = "JBIMA0000";
    private static final String JBI_INSTANCE_NAME = "JBI_INSTANCE_NAME";

    private synchronized ObjectFactory getObjectFactory() throws JAXBException {
        if (this.mObjFactory == null) {
            this.mObjFactory = new ObjectFactory();
        }
        return this.mObjFactory;
    }

    public Message createMessage(String jbiTaskMsg) throws ManagementException {
        return new Message(jbiTaskMsg);
    }

    public MessageBuilder(StringTranslator translator) throws ManagementException {
        try {
            this.mTranslator = translator;
            this.mLocalTranslator = EnvironmentAccess.getContext().getStringTranslator("com.sun.jbi.management");
            this.mLog = Logger.getLogger("com.sun.jbi.management");
        }
        catch (Exception ex) {
            throw new ManagementException(ex);
        }
    }

    public String buildFrameworkMessage(String taskId, TaskResult taskResult, List<ComponentMessageHolder> compMsgs) throws ManagementException {
        return this.buildFrameworkMessage(taskId, taskResult, null, null, new String[0], null, compMsgs);
    }

    public String buildFrameworkMessage(String taskId, TaskResult taskResult) throws ManagementException {
        return this.buildFrameworkMessage(taskId, taskResult, null, null, new String[0], null);
    }

    public String buildFrameworkMessage(String taskId, TaskResult taskResult, MessageType messageType, String message, String[] params, String token, List<ComponentMessageHolder> compMsgs) throws ManagementException {
        try {
            message = MessageBuilder.getMessageString(message);
            JbiTask jbiTaskMsg = this.buildTaskMsg(taskId, taskResult, messageType, message, params, token);
            if (!compMsgs.isEmpty()) {
                this.appendComponentTaskResultMessages(jbiTaskMsg, compMsgs);
            }
            return this.getString(jbiTaskMsg);
        }
        catch (JAXBException jex) {
            throw new ManagementException(jex);
        }
    }

    public String buildFrameworkMessage(String taskId, TaskResult taskResult, MessageType messageType, String message, String[] params, String token) throws ManagementException {
        ArrayList<ComponentMessageHolder> compMsgs = new ArrayList<ComponentMessageHolder>();
        return this.buildFrameworkMessage(taskId, taskResult, messageType, message, params, token, compMsgs);
    }

    public String buildExceptionMessage(String taskId, Throwable ex) throws ManagementException {
        try {
            String exMessage = ex.getMessage();
            if (exMessage != null && MessageBuilder.isXmlString(exMessage)) {
                return exMessage;
            }
            JbiTask taskMsg = null;
            if (MessageBuilder.isLocalizedMessage(exMessage)) {
                taskMsg = this.buildTaskMsg(taskId, TaskResult.FAILED, MessageType.ERROR, MessageBuilder.getMessageString(ex.getMessage()), new String[0], MessageBuilder.getMessageToken(exMessage));
                ex = ex.getCause();
            } else {
                taskMsg = this.buildTaskMsg(taskId, TaskResult.FAILED, MessageType.ERROR, ex.getMessage(), new String[0], null);
            }
            if (ex != null) {
                List<ExceptionInfo> exList = taskMsg.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getExceptionInfo();
                this.appendExceptionInfo(exList, ex);
                ex.printStackTrace();
            }
            return this.getString(taskMsg);
        }
        catch (JAXBException jex) {
            throw new ManagementException(jex);
        }
    }

    public String getStackTrace(Throwable exObj) {
        StackTraceElement[] stckTrElem = exObj.getStackTrace();
        StringBuffer sb = new StringBuffer("");
        if (stckTrElem != null) {
            for (StackTraceElement stckTrElem1 : stckTrElem) {
                String stckTrace = stckTrElem1.toString();
                sb.append(stckTrace);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String getString(JbiTaskResult jbiTaskMsg) throws ManagementException {
        String message = null;
        if (jbiTaskMsg != null) {
            StringWriter sw = new StringWriter();
            try {
                this.marshal(jbiTaskMsg, sw);
                message = sw.toString();
            }
            catch (Exception ex) {
                throw new ManagementException(ex);
            }
            finally {
                try {
                    sw.close();
                }
                catch (IOException ioex) {}
            }
        }
        return message;
    }

    public static String getMessageToken(String message) {
        if (MessageBuilder.isLocalizedMessage(message) && message.length() >= 9) {
            return message.substring(0, 9);
        }
        return JBIMA0000;
    }

    public static String getMessageString(String message) {
        String A_COLON = ":";
        String A_SPACE = " ";
        String FILLER_TEMPLATE = ": ";
        String ID_TEMPLATE = "JBIxxnnnn";
        String U_COLON = "\uff1a";
        String U_NBSP = "\u00a0";
        if (MessageBuilder.isLocalizedMessage(message)) {
            if ("JBIxxnnnn".length() + ": ".length() < message.length()) {
                int textStartsAt = "JBIxxnnnn".length();
                for (int i = 0; i < ": ".length(); ++i) {
                    String next = message.substring(textStartsAt, textStartsAt + 1);
                    if (!":".equals(next) && !" ".equals(next) && !"\uff1a".equals(next) && !"\u00a0".equals(next)) continue;
                    ++textStartsAt;
                }
                return message.substring(textStartsAt);
            }
            return "";
        }
        return message;
    }

    public void throwManagementException(String taskId, String msgKey, String[] params) throws ManagementException {
        String message = this.mTranslator.getString(msgKey, (Object[])params);
        String response = this.buildFrameworkMessage(taskId, TaskResult.FAILED, MessageType.ERROR, MessageBuilder.getMessageString(message), params, MessageBuilder.getMessageToken(message));
        this.mLog.fine(response);
        throw new ManagementException(response);
    }

    public List<ServiceUnitInfo> getSuccessfulServiceUnits(String jbiTaskMsg, List<ServiceUnitInfo> suInfoList) throws ManagementException {
        ArrayList<ServiceUnitInfo> suList = new ArrayList<ServiceUnitInfo>();
        JbiTask jbiTask = this.getJbiTaskFromString(jbiTaskMsg);
        if (jbiTask != null) {
            List<ComponentTaskResult> compResults = jbiTask.getJbiTaskResult().getComponentTaskResult();
            int i = 0;
            for (ComponentTaskResult compResult : compResults) {
                TaskResultDetailsElement taskDetails = compResult.getComponentTaskResultDetails().getTaskResultDetails();
                String taskResult = taskDetails.getTaskResult();
                if (TaskResult.SUCCESS != TaskResult.valueOf(taskResult)) continue;
                boolean matchFound = false;
                ServiceUnitInfo suInfo = null;
                while (!matchFound && i < suInfoList.size()) {
                    if (!(suInfo = suInfoList.get(i++)).getTargetComponent().equals(compResult.getComponentName())) {
                        Object[] params = new String[]{suInfo.getName(), suInfo.getTargetComponent()};
                        String wrnMsg = this.mLocalTranslator.getString("DS_SU_OP_FAILED", params);
                        continue;
                    }
                    matchFound = true;
                }
                if (!matchFound) continue;
                suList.add(suInfo);
            }
        }
        return suList;
    }

    public String buildCompositeExceptionMessage(String taskId, Map<String, Throwable> exceptionMap) throws ManagementException {
        ArrayList<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
        ArrayList<TaskStatusMsg> taskMsgs = new ArrayList<TaskStatusMsg>();
        ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>();
        ArrayList<MessageType> msgTypes = new ArrayList<MessageType>();
        Set<String> instances = exceptionMap.keySet();
        try {
            for (String instance : instances) {
                List<ExceptionInfo> instExceptions;
                List<TaskStatusMsg> instTaskMsgs;
                Exception ex = (Exception)exceptionMap.get(instance);
                JbiTask jbiTask = this.getJbiTaskMessage(taskId, ex);
                taskResults.add(this.getTaskResult(jbiTask));
                MessageType msgType = this.getMessageType(jbiTask);
                if (msgType != null) {
                    msgTypes.add(msgType);
                }
                if (!(instTaskMsgs = this.getTaskStatusMsgs(jbiTask)).isEmpty()) {
                    taskMsgs.add(this.buildTaskStatusMsg(instance, JBI_INSTANCE_NAME, new String[0]));
                }
                if (!(instExceptions = this.getExceptionInfos(jbiTask)).isEmpty()) {
                    exceptions.add(this.buildExceptionInfo(instance, JBI_INSTANCE_NAME, new String[0]));
                }
                taskMsgs.addAll(instTaskMsgs);
                exceptions.addAll(instExceptions);
            }
            JbiTask compositeTask = null;
            compositeTask = this.buildTaskMsg(taskId, this.getEffectiveTaskResult(taskResults, true), this.getEffectiveMessageType(msgTypes), null, new String[0], null);
            compositeTask = this.appendTaskMsgs(compositeTask, taskMsgs);
            compositeTask = this.appendExceptionInfos(compositeTask, exceptions);
            return this.getString(compositeTask);
        }
        catch (JAXBException jex) {
            throw new ManagementException(jex);
        }
    }

    public Message buildCompositeMessage(String taskId, Map<String, String> responseMap, Map<String, Throwable> exceptionMap, boolean requireAllSuccess) throws ManagementException {
        TaskResult rslt;
        Set<String> instances;
        ArrayList<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
        ArrayList<TaskStatusMsg> taskMsgs = new ArrayList<TaskStatusMsg>();
        ComponentInstanceResult[] compResultData = null;
        HashMap<String, JbiTask> jbiTasks = new HashMap<String, JbiTask>();
        ArrayList<TaskResult> rslts = new ArrayList<TaskResult>();
        if (!responseMap.isEmpty()) {
            instances = responseMap.keySet();
            for (String instance : instances) {
                JbiTask jbiTask = this.getJbiTaskFromString(responseMap.get(instance));
                rslt = TaskResult.valueOf(jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getTaskResult());
                rslts.add(rslt);
                jbiTasks.put(instance, jbiTask);
            }
        }
        if (!exceptionMap.isEmpty()) {
            instances = exceptionMap.keySet();
            for (String instance : instances) {
                Exception ex = (Exception)exceptionMap.get(instance);
                JbiTask jbiTask = this.getJbiTaskMessage(taskId, ex);
                TaskResult rslt2 = TaskResult.valueOf(jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getTaskResult());
                rslts.add(rslt2);
                jbiTasks.put(instance, jbiTask);
            }
        }
        JbiTask compositeTask = null;
        try {
            compResultData = this.extractMessageData(jbiTasks, taskMsgs, exceptions, compResultData);
            compositeTask = this.buildTaskMsg(taskId, TaskResult.FAILED, MessageType.ERROR, null, new String[0], null);
            compositeTask = this.appendTaskMsgs(compositeTask, taskMsgs);
            compositeTask = this.appendExceptionInfos(compositeTask, exceptions);
            List<ComponentTaskResult> compResults = this.buildComponentTaskResults(taskId, compResultData, requireAllSuccess);
            compositeTask = this.appendComponentTaskResult(compositeTask, compResults);
            for (ComponentTaskResult compResult : compResults) {
                rslt = TaskResult.valueOf(compResult.getComponentTaskResultDetails().getTaskResultDetails().getTaskResult());
                rslts.add(rslt);
            }
            TaskResult theResult = TaskResult.SUCCESS;
            if (!rslts.isEmpty()) {
                theResult = this.getEffectiveTaskResult(rslts, requireAllSuccess);
            } else if (responseMap.isEmpty() && !exceptionMap.isEmpty()) {
                theResult = TaskResult.FAILED;
            }
            if (TaskResult.SUCCESS == theResult) {
                TaskResultDetailsElement taskDetails = compositeTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails();
                taskDetails.setTaskResult(theResult.toString());
                MessageType type = this.getEffectiveMessageType(rslts, requireAllSuccess);
                taskDetails.setMessageType(type.toString());
            }
            return new Message(compositeTask);
        }
        catch (JAXBException jex) {
            throw new ManagementException(jex);
        }
    }

    String buildComponentMessage(ComponentMessageHolder msgObject) throws Exception {
        return this.getString(this.buildComponentTaskResult(msgObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXmlString(String str) {
        boolean isXmlString = false;
        if (str != null) {
            try {
                if (sXmlParser == null) {
                    sXmlParser = SAXParserFactory.newInstance().newSAXParser();
                }
                SAXParser sAXParser = sXmlParser;
                synchronized (sAXParser) {
                    sXmlParser.parse(new InputSource(new StringReader(str)), new DefaultHandler());
                }
                isXmlString = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isXmlString;
    }

    public static boolean isLocalizedMessage(String message) {
        boolean isLocMsg = false;
        if (message != null) {
            isLocMsg = message.trim().startsWith(TOKEN_PREFIX) && message.length() >= 9;
        }
        return isLocMsg;
    }

    private void appendExceptionInfo(List<ExceptionInfo> exList, Throwable ex) throws JAXBException {
        int nestingLevel = 1;
        while (ex != null) {
            if (ex.getMessage() == null || ex.getMessage().compareTo("") == 0) {
                ++nestingLevel;
                ex = ex.getCause();
                continue;
            }
            ExceptionInfo exInfo = this.getObjectFactory().createExceptionInfo();
            exInfo.setNestingLevel(String.valueOf(nestingLevel));
            MsgLocInfo msgLocInfo = this.buildMsgLocInfo(MessageBuilder.getMessageString(ex.getMessage()), MessageBuilder.getMessageToken(ex.getMessage()), new String[0]);
            exInfo.setMsgLocInfo(msgLocInfo);
            exInfo.setStackTrace(this.getStackTrace(ex));
            exList.add(exInfo);
            ++nestingLevel;
            ex = ex.getCause();
        }
    }

    private void appendExceptionInfo(List<ExceptionInfo> exList, Throwable ex, ComponentMessageHolder compMsg) throws JAXBException {
        int nestingLevel = 1;
        while (ex != null) {
            ExceptionInfo exInfo = this.getObjectFactory().createExceptionInfo();
            exInfo.setNestingLevel(String.valueOf(nestingLevel));
            MsgLocInfo msgLocInfo = null;
            msgLocInfo = compMsg.getLocMessage(nestingLevel) != null ? this.buildMsgLocInfo(compMsg.getLocMessage(nestingLevel), compMsg.getLocToken(nestingLevel), compMsg.getLocParam(nestingLevel)) : this.buildMsgLocInfo(ex.toString(), null, new String[0]);
            exInfo.setMsgLocInfo(msgLocInfo);
            exInfo.setStackTrace(this.getStackTrace(ex));
            exList.add(exInfo);
            ++nestingLevel;
            ex = ex.getCause();
        }
    }

    private JbiTask buildTaskMsg(String taskId, TaskResult taskResult, MessageType messageType, String message, String[] params, String token) throws JAXBException {
        JbiTask jbiTask = this.getObjectFactory().createJbiTask();
        JbiTaskResultElement jbiTaskMsgType = this.getObjectFactory().createJbiTaskResultElement();
        FrmwkTaskResult fmwkTaskResult = this.getObjectFactory().createFrmwkTaskResult();
        FrmwkTaskResultDetails fmwkTaskResultDetails = this.getObjectFactory().createFrmwkTaskResultDetails();
        TaskResultDetailsElement taskResultDetails = this.getObjectFactory().createTaskResultDetailsElement();
        taskResultDetails.setTaskId(taskId);
        taskResultDetails.setTaskResult(taskResult.toString());
        if (messageType != null) {
            taskResultDetails.setMessageType(messageType.toString());
        }
        if (message != null) {
            TaskStatusMsg taskStatusMsg = this.buildTaskStatusMsg(message, token, params);
            taskResultDetails.getTaskStatusMsg().add(taskStatusMsg);
        }
        fmwkTaskResultDetails.setLocale(Locale.getDefault().toString());
        fmwkTaskResultDetails.setTaskResultDetails(taskResultDetails);
        fmwkTaskResult.setFrmwkTaskResultDetails(fmwkTaskResultDetails);
        jbiTaskMsgType.setFrmwkTaskResult(fmwkTaskResult);
        jbiTask.setJbiTaskResult(jbiTaskMsgType);
        jbiTask.setVersion(new BigDecimal("1.0"));
        return jbiTask;
    }

    private TaskStatusMsg buildTaskStatusMsg(String message, String token, String[] params) throws JAXBException {
        MsgLocInfo msgLocInfo = this.buildMsgLocInfo(message, token, params);
        TaskStatusMsg taskStatusMsg = this.getObjectFactory().createTaskStatusMsg();
        taskStatusMsg.setMsgLocInfo(msgLocInfo);
        return taskStatusMsg;
    }

    private ExceptionInfo buildExceptionInfo(String message, String token, String[] params) throws JAXBException {
        MsgLocInfo msgLocInfo = this.buildMsgLocInfo(message, token, params);
        ExceptionInfo exceptionInfo = this.getObjectFactory().createExceptionInfo();
        exceptionInfo.setMsgLocInfo(msgLocInfo);
        exceptionInfo.setNestingLevel("0");
        return exceptionInfo;
    }

    private MsgLocInfo buildMsgLocInfo(String message, String token, String[] params) throws JAXBException {
        MsgLocInfo msgLocInfo = this.getObjectFactory().createMsgLocInfo();
        msgLocInfo.setLocMessage(message);
        if (token != null) {
            msgLocInfo.setLocToken(token);
        } else {
            msgLocInfo.setLocToken(JBIMA0000);
        }
        List<String> locParams = msgLocInfo.getLocParam();
        for (String param : params) {
            locParams.add(param);
        }
        return msgLocInfo;
    }

    private JbiTask getJbiTaskFromString(String jbiTaskMsg) throws ManagementException {
        try {
            StringBuffer strBuf = new StringBuffer(jbiTaskMsg);
            return (JbiTask)this.unmarshal(new StreamSource(new StringReader(strBuf.toString())));
        }
        catch (Exception jex) {
            throw new ManagementException(jex);
        }
    }

    private JbiTask getJbiTaskMessage(String taskId, Exception ex) throws ManagementException {
        JbiTask jbiTask = null;
        if (MessageBuilder.isXmlString(ex.getMessage())) {
            jbiTask = this.getJbiTaskFromString(ex.getMessage());
        } else {
            try {
                jbiTask = this.buildTaskMsg(taskId, TaskResult.FAILED, MessageType.ERROR, ex.getMessage(), new String[0], null);
                List<ExceptionInfo> exList = jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getExceptionInfo();
                this.appendExceptionInfo(exList, ex);
            }
            catch (JAXBException jex) {
                throw new ManagementException(jex);
            }
        }
        return jbiTask;
    }

    private void appendComponentTaskResultMessages(JbiTask jbiTaskMsg, List<ComponentMessageHolder> compMsgs) throws JAXBException {
        JbiTaskResultElement taskResult;
        if (jbiTaskMsg != null && (taskResult = jbiTaskMsg.getJbiTaskResult()) != null) {
            List<ComponentTaskResult> comTaskResults = taskResult.getComponentTaskResult();
            for (ComponentMessageHolder compMsg : compMsgs) {
                comTaskResults.add(this.buildComponentTaskResult(compMsg));
            }
        }
    }

    private ComponentTaskResult buildComponentTaskResult(ComponentMessageHolder compMsg) throws JAXBException {
        ComponentTaskResult compRslt = this.getObjectFactory().createComponentTaskResult();
        compRslt.setComponentName(compMsg.getComponentName());
        TaskResultDetailsElement taskResultDetailsElement = this.getObjectFactory().createTaskResultDetailsElement();
        TaskResultDetails taskResultDetails = this.getObjectFactory().createTaskResultDetails();
        taskResultDetailsElement.setTaskId(compMsg.getTaskName());
        taskResultDetailsElement.setTaskResult(compMsg.getTaskResult());
        if (compMsg.getStatusMessageType() != null) {
            taskResultDetailsElement.setMessageType(MessageType.valueOf(compMsg.getStatusMessageType()).toString());
        }
        if (compMsg.getExceptionObject() != null) {
            this.appendExceptionInfo(taskResultDetailsElement.getExceptionInfo(), compMsg.getExceptionObject(), compMsg);
        }
        taskResultDetails.setTaskResultDetails(taskResultDetailsElement);
        compRslt.setComponentTaskResultDetails(taskResultDetails);
        return compRslt;
    }

    private String getString(ComponentTaskResult compTaskResult) throws ManagementException {
        String message = null;
        if (compTaskResult != null) {
            StringWriter sw = new StringWriter();
            try {
                this.marshal(compTaskResult, sw);
                message = sw.toString();
            }
            catch (Exception ex) {
                throw new ManagementException(ex);
            }
            finally {
                try {
                    sw.close();
                }
                catch (IOException ioex) {}
            }
        }
        return message;
    }

    private List<TaskStatusMsg> getTaskStatusMsgs(JbiTask jbiTask) {
        return jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getTaskStatusMsg();
    }

    private List<ExceptionInfo> getExceptionInfos(JbiTask jbiTask) {
        return jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getExceptionInfo();
    }

    private JbiTask appendTaskMsgs(JbiTask jbiTask, List<TaskStatusMsg> taskMsgs) {
        TaskResultDetailsElement details = jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails();
        for (TaskStatusMsg taskMsg : taskMsgs) {
            details.getTaskStatusMsg().add(taskMsg);
        }
        return jbiTask;
    }

    private JbiTask appendExceptionInfos(JbiTask jbiTask, List<ExceptionInfo> exceptions) {
        TaskResultDetailsElement details = jbiTask.getJbiTaskResult().getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails();
        for (ExceptionInfo exInfo : exceptions) {
            details.getExceptionInfo().add(exInfo);
        }
        return jbiTask;
    }

    private List<ComponentTaskResult> buildComponentTaskResults(String taskId, ComponentInstanceResult[] compResultData, boolean requireAllSuccess) throws JAXBException {
        ArrayList<ComponentTaskResult> compResults = new ArrayList<ComponentTaskResult>();
        ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>();
        for (ComponentInstanceResult compInstResult : compResultData) {
            ComponentTaskResult compRslt = this.getObjectFactory().createComponentTaskResult();
            compRslt.setComponentName(compInstResult.getComponentName());
            TaskResultDetailsElement taskResultDetails = this.getObjectFactory().createTaskResultDetailsElement();
            taskResultDetails.setTaskId(taskId);
            Map<String, TaskResultDetailsElement> compInstanceDetails = compInstResult.getInstanceResults();
            Set<String> instances = compInstanceDetails.keySet();
            for (String instance : instances) {
                TaskResultDetailsElement details = compInstanceDetails.get(instance);
                List<TaskStatusMsg> instTaskMsgs = details.getTaskStatusMsg();
                if (!instTaskMsgs.isEmpty()) {
                    taskResultDetails.getTaskStatusMsg().add(this.buildTaskStatusMsg(instance, JBI_INSTANCE_NAME, new String[0]));
                }
                taskResultDetails.getTaskStatusMsg().addAll(instTaskMsgs);
                List<ExceptionInfo> instExceptions = details.getExceptionInfo();
                if (!instExceptions.isEmpty()) {
                    taskResultDetails.getExceptionInfo().add(this.buildExceptionInfo(instance, JBI_INSTANCE_NAME, new String[0]));
                }
                taskResultDetails.getExceptionInfo().addAll(instExceptions);
                taskResults.add(TaskResult.valueOf(details.getTaskResult()));
            }
            TaskResult rslt = this.getEffectiveTaskResult(taskResults, requireAllSuccess);
            taskResultDetails.setTaskResult(rslt.toString());
            MessageType type = this.getEffectiveMessageType(taskResults, requireAllSuccess);
            taskResultDetails.setMessageType(type.toString());
            TaskResultDetails compTaskResultDetails = this.getObjectFactory().createTaskResultDetails();
            compTaskResultDetails.setTaskResultDetails(taskResultDetails);
            compRslt.setComponentTaskResultDetails(compTaskResultDetails);
            compResults.add(compRslt);
        }
        return compResults;
    }

    private ComponentInstanceResult[] extractMessageData(Map<String, JbiTask> jbiTasks, List<TaskStatusMsg> taskMsgs, List<ExceptionInfo> exceptions, ComponentInstanceResult[] compResultData) throws JAXBException {
        Set<String> instances = jbiTasks.keySet();
        for (String instance : instances) {
            JbiTask jbiTask = jbiTasks.get(instance);
            List<TaskStatusMsg> instTaskMsgs = this.getTaskStatusMsgs(jbiTask);
            List<ExceptionInfo> instExceptions = this.getExceptionInfos(jbiTask);
            if (!instTaskMsgs.isEmpty()) {
                taskMsgs.add(this.buildTaskStatusMsg(instance, JBI_INSTANCE_NAME, new String[0]));
            }
            taskMsgs.addAll(instTaskMsgs);
            if (!instExceptions.isEmpty()) {
                exceptions.add(this.buildExceptionInfo(instance, JBI_INSTANCE_NAME, new String[0]));
            }
            exceptions.addAll(instExceptions);
            List<ComponentTaskResult> compResults = jbiTask.getJbiTaskResult().getComponentTaskResult();
            int compOrder = 0;
            if (compResults.size() > 0 && compResultData == null) {
                compResultData = new ComponentInstanceResult[compResults.size()];
            }
            for (ComponentTaskResult compResult : compResults) {
                String compName = compResult.getComponentName();
                if (compResultData[compOrder] == null) {
                    HashMap instMap = new HashMap();
                    compResultData[compOrder] = new ComponentInstanceResult(compName, new HashMap<String, TaskResultDetailsElement>());
                }
                TaskResultDetailsElement taskDetails = compResult.getComponentTaskResultDetails().getTaskResultDetails();
                Map<String, TaskResultDetailsElement> instMap = compResultData[compOrder].getInstanceResults();
                instMap.put(instance, taskDetails);
                ++compOrder;
            }
        }
        if (compResultData == null) {
            compResultData = new ComponentInstanceResult[]{};
        }
        return compResultData;
    }

    private TaskResult getEffectiveTaskResult(List<TaskResult> taskResults, boolean requireAllSuccess) {
        TaskResult rslt = TaskResult.FAILED;
        if (requireAllSuccess) {
            rslt = taskResults.contains((Object)TaskResult.FAILED) ? TaskResult.FAILED : TaskResult.SUCCESS;
        } else if (taskResults.contains((Object)TaskResult.SUCCESS)) {
            rslt = TaskResult.SUCCESS;
        }
        return rslt;
    }

    private MessageType getEffectiveMessageType(List<TaskResult> taskResults, boolean requireAllSuccess) {
        MessageType type = MessageType.INFO;
        if (requireAllSuccess) {
            type = taskResults.contains((Object)TaskResult.FAILED) ? MessageType.ERROR : MessageType.INFO;
        } else if (taskResults.contains((Object)TaskResult.FAILED)) {
            type = MessageType.WARNING;
        }
        return type;
    }

    private JbiTask appendComponentTaskResult(JbiTask jbiTask, List<ComponentTaskResult> compResults) {
        jbiTask.getJbiTaskResult().getComponentTaskResult().addAll(compResults);
        return jbiTask;
    }

    private TaskResult getTaskResult(JbiTask jbiTask) {
        TaskResult rslt = TaskResult.FAILED;
        TaskResultDetailsElement details = this.getTaskResultDetails(jbiTask);
        if (details != null) {
            String result = details.getTaskResult();
            rslt = TaskResult.valueOf(result);
        }
        return rslt;
    }

    private MessageType getMessageType(JbiTask jbiTask) {
        String msgType;
        MessageType type = null;
        TaskResultDetailsElement details = this.getTaskResultDetails(jbiTask);
        if (details != null && (msgType = details.getMessageType()) != null) {
            type = MessageType.valueOf(msgType);
        }
        return type;
    }

    private TaskResultDetailsElement getTaskResultDetails(JbiTask jbiTask) {
        FrmwkTaskResultDetails details;
        FrmwkTaskResult fmwkRslt;
        TaskResultDetailsElement detailsType = null;
        JbiTaskResultElement jbiTaskRsltType = jbiTask.getJbiTaskResult();
        if (jbiTaskRsltType != null && (fmwkRslt = jbiTaskRsltType.getFrmwkTaskResult()) != null && (details = fmwkRslt.getFrmwkTaskResultDetails()) != null) {
            detailsType = details.getTaskResultDetails();
        }
        return detailsType;
    }

    private MessageType getEffectiveMessageType(List<MessageType> msgTypes) {
        MessageType msgType = null;
        if (!msgTypes.isEmpty()) {
            msgType = msgTypes.contains((Object)MessageType.ERROR) ? MessageType.ERROR : (msgTypes.contains((Object)MessageType.WARNING) ? MessageType.WARNING : MessageType.INFO);
        }
        return msgType;
    }

    private synchronized JAXBContext getJaxbContext() throws Exception {
        if (this.mJaxbContext == null) {
            ClassLoader cl = Class.forName("com.sun.jbi.management.message.JbiTaskResult").getClassLoader();
            this.mJaxbContext = JAXBContext.newInstance((String)"com.sun.jbi.management.message", (ClassLoader)cl);
        }
        return this.mJaxbContext;
    }

    private synchronized void marshal(Object jaxbElement, Writer writer) throws Exception {
        if (this.mWriter == null) {
            this.mWriter = this.getJaxbContext().createMarshaller();
        }
        this.mWriter.marshal(jaxbElement, writer);
    }

    private synchronized Object unmarshal(StreamSource input) throws Exception {
        if (this.mReader == null) {
            this.mReader = this.getJaxbContext().createUnmarshaller();
        }
        return this.mReader.unmarshal((Source)input);
    }

    public class Message {
        private JbiTaskResult mTaskMsg;

        public Message(JbiTask task) {
            this.mTaskMsg = task;
        }

        public Message(String jbiTaskMsg) throws ManagementException {
            this.mTaskMsg = MessageBuilder.this.getJbiTaskFromString(jbiTaskMsg);
        }

        public boolean isSuccess() {
            JbiTaskResultElement jbiTaskMsgType = this.mTaskMsg.getJbiTaskResult();
            String taskResult = jbiTaskMsgType.getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getTaskResult();
            return TaskResult.SUCCESS == TaskResult.valueOf(taskResult);
        }

        public boolean isFailure() {
            JbiTaskResultElement jbiTaskMsgType = this.mTaskMsg.getJbiTaskResult();
            String taskResult = jbiTaskMsgType.getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getTaskResult();
            return TaskResult.FAILED == TaskResult.valueOf(taskResult);
        }

        public boolean isSuccessWithWarning() {
            String msgType;
            boolean isSuccess = false;
            boolean isWarning = false;
            JbiTaskResultElement jbiTaskMsgType = this.mTaskMsg.getJbiTaskResult();
            String taskResult = jbiTaskMsgType.getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getTaskResult();
            if (TaskResult.SUCCESS == TaskResult.valueOf(taskResult)) {
                isSuccess = true;
            }
            if (MessageType.WARNING == MessageType.valueOf(msgType = jbiTaskMsgType.getFrmwkTaskResult().getFrmwkTaskResultDetails().getTaskResultDetails().getMessageType())) {
                isWarning = true;
            }
            return isSuccess && isWarning;
        }

        public String getMessage() throws ManagementException {
            return MessageBuilder.this.getString(this.mTaskMsg);
        }
    }

    public static enum MessageType {
        ERROR,
        WARNING,
        INFO;

    }

    public static enum TaskResult {
        SUCCESS,
        FAILED;

    }
}

