/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.descriptor;

import com.sun.jbi.ComponentType;
import com.sun.jbi.management.descriptor.Component;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.internal.support.DOMUtil;
import com.sun.jbi.management.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class ComponentDescriptor {
    private Component mCompType;
    private Logger mLog;
    private static final String CONFIGURATION = "Configuration";
    private static final String LOGGING = "Logging";
    private static final String OBSERVER = "Observer";

    public ComponentDescriptor(Jbi jbi) throws IllegalArgumentException {
        this.mCompType = jbi.getComponent();
        this.mLog = Logger.getLogger("com.sun.jbi.management");
        if (this.mCompType == null) {
            throw new IllegalArgumentException();
        }
    }

    public ComponentDescriptor() {
    }

    public String getName() {
        if (this.mCompType.getIdentification() != null) {
            return StringHelper.trim(this.mCompType.getIdentification().getName());
        }
        return "";
    }

    public String getDescription() {
        if (this.mCompType.getIdentification() != null) {
            return StringHelper.trim(this.mCompType.getIdentification().getDescription());
        }
        return "";
    }

    public ComponentType getComponentType() {
        ComponentType compType = null;
        String compTypeStr = StringHelper.trim(this.mCompType.getType());
        if (compTypeStr.equals("binding-component")) {
            compType = ComponentType.BINDING;
        } else if (compTypeStr.equals("service-engine")) {
            compType = ComponentType.ENGINE;
        }
        return compType;
    }

    public boolean isComponentClassLoaderSelfFirst() {
        return "self-first".equals(StringHelper.trim(this.mCompType.getComponentClassLoaderDelegation()));
    }

    public boolean isBootstrapClassLoaderSelfFirst() {
        return "self-first".equals(StringHelper.trim(this.mCompType.getBootstrapClassLoaderDelegation()));
    }

    public List<String> getComponentClassPathElements() {
        if (this.mCompType.getComponentClassPath() != null) {
            return StringHelper.trim(this.mCompType.getComponentClassPath().getPathElement());
        }
        return new ArrayList<String>();
    }

    public List<String> getBootstrapClassPathElements() {
        if (this.mCompType.getBootstrapClassPath() != null) {
            return StringHelper.trim(this.mCompType.getBootstrapClassPath().getPathElement());
        }
        return new ArrayList<String>();
    }

    public String getBootstrapClassName() {
        String bootClassName = StringHelper.trim(this.mCompType.getBootstrapClassName());
        return bootClassName;
    }

    public String getComponentClassName() {
        String compClassName = "";
        if (this.mCompType.getComponentClassName() != null) {
            compClassName = StringHelper.trim(this.mCompType.getComponentClassName().getContent());
        }
        return compClassName;
    }

    public List<String> getSharedLibraryIds() {
        ArrayList<String> sls = new ArrayList<String>();
        List<Component.SharedLibrary> slList = this.mCompType.getSharedLibraryList();
        for (Component.SharedLibrary sl : slList) {
            String slName = StringHelper.trim(sl.getContent());
            if ("".equals(slName)) continue;
            sls.add(slName);
        }
        return sls;
    }

    public String getComponentConfigurationNS() {
        String ns = "";
        List<Element> extensions = this.mCompType.getAnyOrAny();
        for (Element element : extensions) {
            if (!element.getLocalName().equals(CONFIGURATION)) continue;
            ns = element.getNamespaceURI();
        }
        return ns;
    }

    public String getComponentConfigurationXml() {
        String xmlStr = null;
        List<Element> extensions = this.mCompType.getAnyOrAny();
        for (Element element : extensions) {
            if (!element.getLocalName().equals(CONFIGURATION)) continue;
            DOMUtil domUtil = new DOMUtil();
            try {
                xmlStr = domUtil.elementToString(element);
            }
            catch (Throwable ex) {
                this.mLog.log(Level.FINE, "Failed to convert configuration element to String", ex);
            }
        }
        return xmlStr;
    }

    public Element getComponentLoggingXml() {
        Element xml = null;
        List<Element> extensions = this.mCompType.getAnyOrAny();
        for (Element element : extensions) {
            if (!element.getLocalName().equals(LOGGING)) continue;
            xml = element;
        }
        return xml;
    }

    public Element getComponentObserverXml() {
        Element xml = null;
        List<Element> extensions = this.mCompType.getAnyOrAny();
        for (Element element : extensions) {
            if (!element.getLocalName().equals(OBSERVER)) continue;
            xml = element;
        }
        return xml;
    }
}

