/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common.server;

import java.io.IOException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.test.server.ResponseActions;
import org.springframework.ws.test.server.ResponseMatcher;
import org.springframework.ws.test.support.AssertionErrors;

public class MockWebServiceClientResponseActions
implements ResponseActions {
    private final MessageContext messageContext;

    public MockWebServiceClientResponseActions(MessageContext messageContext) {
        Assert.notNull((Object)messageContext, (String)"'messageContext' must not be null");
        this.messageContext = messageContext;
    }

    public ResponseActions andExpect(ResponseMatcher responseMatcher) {
        WebServiceMessage request = this.messageContext.getRequest();
        WebServiceMessage response = this.messageContext.getResponse();
        if (response == null) {
            AssertionErrors.fail((String)"No response received");
            return null;
        }
        try {
            responseMatcher.match(request, response);
            return this;
        }
        catch (IOException ex) {
            AssertionErrors.fail((String)ex.getMessage());
            return null;
        }
    }
}

