/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.util.Collections;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xpath.Jaxp13XPathTemplate;

class XsltUtil
extends TransformerObjectSupport {
    private static final Map<String, String> NAMESPACES = Collections.singletonMap("xs", "http://www.w3.org/1999/XSL/Transform");
    private final Map<String, Object> parameters;

    public XsltUtil(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    boolean isTemplate(Source context) {
        Jaxp13XPathTemplate template = new Jaxp13XPathTemplate();
        template.setNamespaces(NAMESPACES);
        return template.evaluateAsBoolean("count(/xs:stylesheet)>0", context);
    }

    Source transform(Source template, Source source) {
        try {
            StringResult transformedExpectedDocument = new StringResult();
            this.transform(template, source, (Result)transformedExpectedDocument);
            return new StringSource(transformedExpectedDocument.toString());
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Transformation error", e);
        }
    }

    void transform(Source template, Source source, Result result) throws TransformerException {
        Transformer transformer = this.getTransformerFactory().newTransformer(template);
        this.setParameters(transformer);
        transformer.transform(source, result);
    }

    private void setParameters(Transformer transformer) {
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

