/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import net.javacrumbs.smock.common.MessageCreator;
import net.javacrumbs.smock.common.TemplateProcessor;
import net.javacrumbs.smock.common.client.ParametrizableResponseCreator;
import net.javacrumbs.smock.common.server.ParametrizableRequestCreator;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;

public class TemplateAwareMessageCreator
extends MessageCreator
implements ParametrizableResponseCreator,
ParametrizableRequestCreator {
    private final Map<String, Object> parameters;
    private final TemplateProcessor templateProcessor;

    public TemplateAwareMessageCreator(Source response, Map<String, Object> parameters, TemplateProcessor templateProcessor) {
        super(response);
        Assert.notNull((Object)templateProcessor, (String)"TemplateProcessor can not be null");
        this.parameters = new HashMap<String, Object>(parameters);
        this.templateProcessor = templateProcessor;
    }

    @Override
    protected Source preprocessSource(URI uri, WebServiceMessage input, WebServiceMessageFactory messageFactory) {
        Source inputSource = input != null ? input.getPayloadSource() : null;
        return this.templateProcessor.processTemplate(this.getSource(), inputSource, this.parameters);
    }

    @Override
    public TemplateAwareMessageCreator withParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public TemplateAwareMessageCreator withParameters(Map<String, Object> additionalParameters) {
        this.parameters.putAll(additionalParameters);
        return this;
    }
}

