/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import javax.xml.transform.Source;
import net.javacrumbs.smock.common.XmlUtil;
import org.springframework.util.Assert;

public class SourceAndControlAssertionError
extends AssertionError {
    private static final long serialVersionUID = 6499060400685231092L;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final String controlLabel;
    private final Source controlSource;
    private final String messageLabel;
    private final Source messageSource;

    public SourceAndControlAssertionError(String message, String messageLabel, Source messageSource, String controlLabel, Source controlSource) {
        super((Object)message);
        Assert.notNull((Object)messageLabel, (String)"messageLabel has to be set");
        Assert.notNull((Object)messageSource, (String)"messageSource has to be set");
        Assert.notNull((Object)controlLabel, (String)"controlLabel has to be set");
        Assert.notNull((Object)controlSource, (String)"controlSource has to be set");
        this.controlLabel = controlLabel;
        this.controlSource = controlSource;
        this.messageLabel = messageLabel;
        this.messageSource = messageSource;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMessage());
        this.appendMessage(builder, this.messageSource, this.messageLabel);
        this.appendMessage(builder, this.controlSource, this.controlLabel);
        return builder.toString();
    }

    private void appendMessage(StringBuilder builder, Source source, String label) {
        String string = this.getMessageString(source);
        if (string != null) {
            builder.append(NEW_LINE);
            builder.append(label);
            builder.append(": ");
            builder.append(string);
        }
    }

    private String getMessageString(Source source) {
        if (source != null) {
            return XmlUtil.serialize(source);
        }
        return null;
    }

    public String getControlLabel() {
        return this.controlLabel;
    }

    public Source getControlSource() {
        return this.controlSource;
    }
}

