/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import net.hasor.core.AppContext;
import net.hasor.spring.beans.ContextFactoryBean;
import net.hasor.spring.xml.AbstractHasorDefinitionParser;
import net.hasor.utils.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class HasorDefinitionParser
extends AbstractHasorDefinitionParser {
    HasorDefinitionParser() {
    }

    @Override
    protected String beanID(Element element, NamedNodeMap attributes) {
        String beanID = this.revertProperty(attributes, "id");
        if (StringUtils.isBlank((String)beanID)) {
            beanID = AppContext.class.getName();
        }
        return beanID.trim();
    }

    @Override
    protected AbstractBeanDefinition parse(Element element, NamedNodeMap attributes, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClass(ContextFactoryBean.class);
        builder.setAutowireMode(4);
        builder.setScope("singleton");
        builder.setLazyInit(false);
        String refProperties = this.revertProperty(attributes, "refProperties");
        if (StringUtils.isNotBlank((String)refProperties)) {
            builder.addPropertyValue("refProperties", (Object)new RuntimeBeanReference(refProperties));
        } else {
            builder.addPropertyValue("refProperties", null);
        }
        String importPropertiesToSettings = this.revertProperty(attributes, "useProperties");
        if (StringUtils.isNotBlank((String)importPropertiesToSettings)) {
            builder.addPropertyValue("useProperties", (Object)importPropertiesToSettings);
        }
        this.exploreElement(element, "mainConfig", node -> {
            String mainConfig = node.getFirstChild().getNodeValue();
            if (StringUtils.isBlank((String)mainConfig)) {
                mainConfig = node.getNodeValue();
            }
            if (StringUtils.isNotBlank((String)mainConfig)) {
                builder.addPropertyValue("mainConfig", (Object)mainConfig);
            }
        });
        HashMap customProperties = new HashMap();
        builder.addPropertyValue("customProperties", customProperties);
        this.exploreElement(element, "property", node -> {
            String key = node.getAttribute("name");
            String value = node.getAttribute("value");
            if (StringUtils.isBlank((String)key)) {
                return;
            }
            if (StringUtils.isBlank((String)value)) {
                customProperties.put(key, node.getTextContent());
            } else {
                customProperties.put(key, value);
            }
        });
        ArrayList<String> loadModules = new ArrayList<String>();
        builder.addPropertyValue("loadModules", loadModules);
        String startWith = this.revertProperty(attributes, "startWith");
        String startWithRef = this.revertProperty(attributes, "startWithRef");
        if (StringUtils.isNotBlank((String)startWith) || StringUtils.isNotBlank((String)startWithRef)) {
            if (StringUtils.isNotBlank((String)startWithRef)) {
                loadModules.add(startWithRef);
            } else {
                BeanDefinitionHolder beanHolder = this.createBeanHolder(startWith, parserContext);
                parserContext.getRegistry().registerBeanDefinition(beanHolder.getBeanName(), beanHolder.getBeanDefinition());
                loadModules.add(beanHolder.getBeanName());
            }
        }
        this.exploreElement(element, "loadModule", node -> {
            String[] packages;
            String scanPackages = node.getAttribute("scanPackages");
            if (StringUtils.isNotBlank((String)scanPackages) && (packages = (String[])Arrays.stream(scanPackages.split(",")).filter(StringUtils::isNotBlank).toArray(String[]::new)).length > 0) {
                builder.addPropertyValue("scanPackages", (Object)packages);
            }
            this.exploreElement((Element)node, "module", eleMode -> {
                String refBean = eleMode.getAttribute("refBean");
                String classType = eleMode.getAttribute("class");
                if (StringUtils.isNotBlank((String)refBean)) {
                    loadModules.add(refBean);
                } else if (StringUtils.isNotBlank((String)classType)) {
                    BeanDefinitionHolder beanHolder = this.createBeanHolder(classType, parserContext);
                    parserContext.getRegistry().registerBeanDefinition(beanHolder.getBeanName(), beanHolder.getBeanDefinition());
                    loadModules.add(beanHolder.getBeanName());
                }
            });
        });
        return builder.getBeanDefinition();
    }

    protected void exploreElement(Element element, String elementName, Consumer<Element> consumer) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element entry;
            if (node.getNodeType() != 1 || !(entry = (Element)node).getLocalName().equals(elementName)) continue;
            consumer.accept(entry);
        }
    }

    protected BeanDefinitionHolder createBeanHolder(String beanType, ParserContext parserContext) {
        return this.createBeanHolder(beanType, parserContext, beanDefinitionBuilder -> {});
    }

    protected BeanDefinitionHolder createBeanHolder(String beanType, ParserContext parserContext, Consumer<BeanDefinitionBuilder> buildBean) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)beanType);
        builder.setAutowireMode(4);
        buildBean.accept(builder);
        AbstractBeanDefinition startWithDefine = builder.getBeanDefinition();
        String beanName = new DefaultBeanNameGenerator().generateBeanName((BeanDefinition)startWithDefine, parserContext.getRegistry());
        return new BeanDefinitionHolder((BeanDefinition)startWithDefine, beanName);
    }
}

