/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.xml;

import net.hasor.core.AppContext;
import net.hasor.spring.beans.TargetFactoryBean;
import net.hasor.spring.xml.AbstractHasorDefinitionParser;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class BeanDefinitionParser
extends AbstractHasorDefinitionParser {
    BeanDefinitionParser() {
    }

    @Override
    protected String beanID(Element element, NamedNodeMap attributes) {
        String beanID = this.revertProperty(attributes, "id");
        if (StringUtils.isBlank((String)beanID)) {
            String refID = super.revertProperty(attributes, "refID");
            if (StringUtils.isBlank((String)refID)) {
                beanID = super.revertProperty(attributes, "refType");
                String refName = super.revertProperty(attributes, "refName");
                if (!StringUtils.isBlank((String)refName)) {
                    beanID = refName + "-" + beanID;
                }
            } else {
                beanID = refID;
            }
        }
        return beanID;
    }

    @Override
    protected AbstractBeanDefinition parse(Element element, NamedNodeMap attributes, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClass(TargetFactoryBean.class);
        String factoryID = this.revertProperty(attributes, "hasorID");
        String refID = this.revertProperty(attributes, "refID");
        String refType = this.revertProperty(attributes, "refType");
        String refName = this.revertProperty(attributes, "refName");
        String lazy = this.revertProperty(attributes, "lazy");
        builder.setLazyInit(((Boolean)ConverterUtils.convert((String)lazy, Boolean.TYPE)).booleanValue());
        if (StringUtils.isBlank((String)factoryID)) {
            factoryID = AppContext.class.getName();
        }
        if (StringUtils.isNotBlank((String)refID) || StringUtils.isNotBlank((String)refType)) {
            builder.addPropertyReference("factory", factoryID);
            builder.addPropertyValue("refID", (Object)refID);
            builder.addPropertyValue("refName", (Object)refName);
            if (StringUtils.isNotBlank((String)refType)) {
                try {
                    ClassLoader classLoader = parserContext.getReaderContext().getBeanClassLoader();
                    Class refTypeClass = ClassUtils.forName((String)refType, (ClassLoader)classLoader);
                    builder.addPropertyValue("refType", (Object)refTypeClass);
                }
                catch (ClassNotFoundException ex) {
                    parserContext.getReaderContext().error("Bean class [" + refType + "] not found", (Object)element, (Throwable)ex);
                }
            }
        } else {
            parserContext.getReaderContext().error("Bean class [" + refType + "] refID and refType ,both undefined.", (Object)element);
        }
        return builder.getBeanDefinition();
    }
}

