/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractHasorDefinitionParser
implements BeanDefinitionParser {
    protected final String revertProperty(NamedNodeMap attributes, String attName) {
        Node attNode = attributes.getNamedItem(attName);
        return attNode != null ? attNode.getNodeValue() : null;
    }

    protected abstract String beanID(Element var1, NamedNodeMap var2);

    protected abstract AbstractBeanDefinition parse(Element var1, NamedNodeMap var2, ParserContext var3);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        NamedNodeMap attributes = element.getAttributes();
        AbstractBeanDefinition definition = this.parse(element, attributes, parserContext);
        if (definition == null) {
            return null;
        }
        return this.registerBean(element, parserContext, attributes, definition);
    }

    private BeanDefinition registerBean(Element element, ParserContext parserContext, NamedNodeMap attributes, AbstractBeanDefinition definition) {
        if (!parserContext.isNested()) {
            try {
                String id = this.beanID(element, attributes);
                if (!StringUtils.hasText((String)id)) {
                    parserContext.getReaderContext().error(this.beanID(element, attributes) + " is undefined. for element '" + element.getLocalName(), (Object)element);
                }
                BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)definition, id);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
                parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(holder));
            }
            catch (BeanDefinitionStoreException ex) {
                parserContext.getReaderContext().error(ex.getMessage(), (Object)element);
                return null;
            }
        }
        return definition;
    }
}

