/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.boot;

import java.util.Collections;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import net.hasor.core.AppContext;
import net.hasor.spring.beans.AbstractTypeSupplierTools;
import net.hasor.spring.boot.EmptyFilter;
import net.hasor.spring.boot.EnableHasorWeb;
import net.hasor.spring.boot.Filter2Interceptor;
import net.hasor.spring.boot.WorkAt;
import net.hasor.utils.ExceptionUtils;
import net.hasor.web.binder.OneConfig;
import net.hasor.web.startup.RuntimeFilter;
import net.hasor.web.startup.RuntimeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
public class WebHasorConfiguration
extends AbstractTypeSupplierTools
implements ImportAware,
WebMvcConfigurer {
    private static Logger logger = LoggerFactory.getLogger(WebHasorConfiguration.class);
    @Autowired
    private AppContext appContext;
    private String filterPath = "/*";
    private int filterOrder = 0;
    private WorkAt filterWorkAt;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Set types = importMetadata.getAnnotationTypes();
        if (!types.contains(EnableHasorWeb.class.getName())) {
            return;
        }
        EnableHasorWeb enableHasor = null;
        try {
            String className = importMetadata.getClassName();
            Class<?> loadClass = this.getSpringClassLoader().loadClass(className);
            enableHasor = loadClass.getAnnotation(EnableHasorWeb.class);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        this.filterPath = enableHasor.path();
        this.filterOrder = 0;
        this.filterWorkAt = enableHasor.at();
        logger.info("@EnableHasorWeb -> filterPath='" + this.filterPath + "', filterOrder='" + this.filterOrder + "', filterWorkAt='" + (Object)((Object)this.filterWorkAt) + "'");
    }

    @Bean
    @ConditionalOnClass(name={"net.hasor.web.startup.RuntimeListener"})
    public ServletListenerRegistrationBean<?> hasorRuntimeListener() {
        Objects.requireNonNull(this.appContext, "AppContext is not inject.");
        return new ServletListenerRegistrationBean((EventListener)new RuntimeListener(this.appContext));
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnClass(name={"net.hasor.web.startup.RuntimeFilter"})
    public FilterRegistrationBean<?> hasorRuntimeFilter() {
        Objects.requireNonNull(this.appContext, "AppContext is not inject.");
        EmptyFilter runtimeFilter = null;
        runtimeFilter = this.filterWorkAt == WorkAt.Filter ? new RuntimeFilter(this.appContext) : new EmptyFilter();
        FilterRegistrationBean filterBean = new FilterRegistrationBean((Filter)runtimeFilter, new ServletRegistrationBean[0]);
        filterBean.setUrlPatterns(Collections.singletonList(this.filterPath));
        filterBean.setOrder(this.filterOrder);
        filterBean.setName(RuntimeFilter.class.getName());
        return filterBean;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        Objects.requireNonNull(this.appContext, "AppContext is not inject.");
        if (this.filterWorkAt != WorkAt.Interceptor) {
            return;
        }
        try {
            RuntimeFilter runtimeFilter = new RuntimeFilter(this.appContext);
            runtimeFilter.init((FilterConfig)new OneConfig("", () -> this.appContext));
            Filter2Interceptor interceptor = new Filter2Interceptor(runtimeFilter);
            String filterPath = this.filterPath;
            if (filterPath.endsWith("/*")) {
                filterPath = filterPath.substring(0, filterPath.length() - 2) + "/**";
            }
            registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(new String[]{filterPath}).order(this.filterOrder);
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }
}

