/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.boot;

import java.util.Collections;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import net.hasor.core.AppContext;
import net.hasor.spring.beans.AbstractTypeSupplierTools;
import net.hasor.spring.boot.EnableHasorWeb;
import net.hasor.utils.ExceptionUtils;
import net.hasor.web.startup.RuntimeFilter;
import net.hasor.web.startup.RuntimeListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
public class WebHasorConfiguration
extends AbstractTypeSupplierTools
implements ImportAware {
    private String filterPath = "/*";
    private int filterOrder = 0;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Set types = importMetadata.getAnnotationTypes();
        if (!types.contains(EnableHasorWeb.class.getName())) {
            return;
        }
        EnableHasorWeb enableHasor = null;
        try {
            String className = importMetadata.getClassName();
            Class<?> loadClass = this.getSpringClassLoader().loadClass(className);
            enableHasor = loadClass.getAnnotation(EnableHasorWeb.class);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        this.filterPath = enableHasor.path();
        this.filterOrder = 0;
    }

    @Bean
    @ConditionalOnClass(name={"net.hasor.web.startup.RuntimeFilter"})
    public FilterRegistrationBean<?> hasorRuntimeFilter() {
        FilterRegistrationBean filterBean = new FilterRegistrationBean((Filter)new RuntimeFilter(), new ServletRegistrationBean[0]);
        filterBean.setUrlPatterns(Collections.singletonList(this.filterPath));
        filterBean.setOrder(this.filterOrder);
        filterBean.setName(RuntimeFilter.class.getName());
        return filterBean;
    }

    @Bean
    @ConditionalOnClass(name={"net.hasor.web.startup.RuntimeListener"})
    public ServletListenerRegistrationBean<?> hasorRuntimeListener(AppContext appContext) {
        appContext = Objects.requireNonNull(appContext, "AppContext is not inject.");
        ServletListenerRegistrationBean listenerBean = new ServletListenerRegistrationBean((EventListener)new RuntimeListener(appContext));
        return listenerBean;
    }
}

