/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.beans;

import java.util.Set;
import java.util.function.Predicate;
import net.hasor.core.ApiBinder;
import net.hasor.core.DimModule;
import net.hasor.core.Module;
import net.hasor.core.TypeSupplier;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.spring.beans.AbstractTypeSupplierTools;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AutoScanPackagesModule
extends AbstractTypeSupplierTools
implements Module,
ApplicationContextAware {
    protected static Logger logger = LoggerFactory.getLogger(AutoScanPackagesModule.class);
    private String[] loadModulePackages = null;
    private Predicate<Class<?>> include;

    public AutoScanPackagesModule(String[] packages) {
        this(packages, null);
    }

    public AutoScanPackagesModule(String[] packages, Predicate<Class<?>> include) {
        this.loadModulePackages = packages;
        this.include = include == null ? Matchers.anyClass() : include;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
    }

    public void loadModule(ApiBinder apiBinder) {
        if (this.loadModulePackages == null) {
            this.loadModulePackages = apiBinder.getEnvironment().getSpanPackage();
        }
        TypeSupplier typeSupplier = this.getTypeSupplier().beforeOther(new TypeSupplier(){

            public <T> T get(Class<? extends T> targetType) {
                try {
                    return targetType.newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntimeException((Throwable)e);
                }
            }
        });
        logger.info("loadModule autoScan='true' scanPackages=" + StringUtils.join((Object[])this.loadModulePackages, (String)","));
        Set classSet = apiBinder.findClass(DimModule.class, this.loadModulePackages);
        apiBinder.loadModule(classSet, this.include, typeSupplier);
    }
}

