/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.MethodInterceptor;
import net.hasor.core.Module;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.db.Level;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.core.JdbcAccessor;
import net.hasor.db.jdbc.core.JdbcConnection;
import net.hasor.db.jdbc.core.JdbcOperationsProvider;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.core.JdbcTemplateProvider;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.interceptor.TransactionInterceptor;
import net.hasor.db.transaction.interceptor.Transactional;
import net.hasor.db.transaction.provider.TransactionManagerProvider;
import net.hasor.db.transaction.provider.TransactionTemplateProvider;
import net.hasor.utils.StringUtils;

public class JdbcModule
implements Module {
    private Set<Level> loadLevel;
    private String dataSourceID;
    private Supplier<DataSource> dataSource;

    public JdbcModule(Level loadLevel, DataSource dataSource) {
        this(new Level[]{loadLevel}, null, (Supplier<DataSource>)new InstanceProvider((Object)Objects.requireNonNull(dataSource)));
    }

    public JdbcModule(Level loadLevel, Supplier<DataSource> dataSource) {
        this(new Level[]{loadLevel}, null, dataSource);
    }

    public JdbcModule(Level loadLevel, String name, DataSource dataSource) {
        this(new Level[]{loadLevel}, name, (Supplier<DataSource>)new InstanceProvider((Object)Objects.requireNonNull(dataSource)));
    }

    public JdbcModule(Level[] loadLevel, DataSource dataSource) {
        this(loadLevel, null, (Supplier<DataSource>)new InstanceProvider((Object)Objects.requireNonNull(dataSource)));
    }

    public JdbcModule(Level[] loadLevel, Supplier<DataSource> dataSource) {
        this(loadLevel, null, dataSource);
    }

    public JdbcModule(Level[] loadLevel, String name, Supplier<DataSource> dataSource) {
        Objects.requireNonNull(loadLevel, "loadLevel is null.");
        Objects.requireNonNull(dataSource, "dataSource Provider is null.");
        this.loadLevel = new HashSet<Level>(Arrays.asList(loadLevel));
        this.dataSourceID = name;
        this.dataSource = dataSource;
    }

    public void loadModule(ApiBinder apiBinder) throws Throwable {
        boolean loadTran;
        boolean loadData = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.DataSource);
        boolean loadJdbc = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.Jdbc);
        boolean bl = loadTran = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.Tran);
        if (loadData) {
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(DataSource.class).toProvider(this.dataSource);
            } else {
                apiBinder.bindType(DataSource.class).nameWith(this.dataSourceID).toProvider(this.dataSource);
            }
        }
        if (loadJdbc) {
            JdbcTemplateProvider tempProvider = new JdbcTemplateProvider(this.dataSource);
            JdbcOperationsProvider operProvider = new JdbcOperationsProvider(this.dataSource);
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(JdbcAccessor.class).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcConnection.class).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcTemplate.class).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcOperations.class).toProvider((Supplier)operProvider);
            } else {
                apiBinder.bindType(JdbcAccessor.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcConnection.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcTemplate.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcOperations.class).nameWith(this.dataSourceID).toProvider((Supplier)operProvider);
            }
        }
        if (loadTran) {
            TransactionManagerProvider managerProvider = new TransactionManagerProvider(this.dataSource);
            TransactionTemplateProvider templateProvider = new TransactionTemplateProvider(this.dataSource);
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(TransactionManager.class).toProvider((Supplier)managerProvider);
                apiBinder.bindType(TransactionTemplate.class).toProvider((Supplier)templateProvider);
            } else {
                apiBinder.bindType(TransactionManager.class).nameWith(this.dataSourceID).toProvider((Supplier)managerProvider);
                apiBinder.bindType(TransactionTemplate.class).nameWith(this.dataSourceID).toProvider((Supplier)templateProvider);
            }
            TransactionInterceptor tranInter = new TransactionInterceptor(this.dataSource);
            Predicate matcherClass = Matchers.annotatedWithClass(Transactional.class);
            Predicate matcherMethod = Matchers.annotatedWithMethod(Transactional.class);
            apiBinder.bindInterceptor(matcherClass, matcherMethod, (MethodInterceptor)tranInter);
        }
    }
}

