/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ReconnConf;
import org.tio.client.TioClientConfig;
import org.tio.core.ChannelContext;
import org.tio.core.maintain.MaintainUtils;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class CloseRunnable
extends AbstractQueueRunnable<ChannelContext> {
    private static final Logger log = LoggerFactory.getLogger(CloseRunnable.class);
    private final Queue<ChannelContext> msgQueue = new ConcurrentLinkedQueue<ChannelContext>();

    public CloseRunnable(Executor executor) {
        super(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runTask() {
        ChannelContext channelContext;
        if (this.msgQueue.isEmpty()) {
            return;
        }
        while ((channelContext = this.msgQueue.poll()) != null) {
            Throwable throwable;
            String remark;
            boolean isNeedRemove;
            block22: {
                block21: {
                    isNeedRemove = channelContext.closeMeta.isNeedRemove;
                    remark = channelContext.closeMeta.remark;
                    throwable = channelContext.closeMeta.throwable;
                    channelContext.stat.timeClosed = System.currentTimeMillis();
                    if (channelContext.tioConfig.getTioListener() != null) {
                        try {
                            channelContext.tioConfig.getTioListener().onBeforeClose(channelContext, throwable, remark, isNeedRemove);
                        }
                        catch (Throwable e) {
                            log.error(e.getMessage(), e);
                        }
                    }
                    if (!channelContext.isClosed() || isNeedRemove) break block21;
                    log.info("{}, {}\u5df2\u7ecf\u5173\u95ed\uff0c\u5907\u6ce8:{}\uff0c\u5f02\u5e38:{}", new Object[]{channelContext.tioConfig, channelContext, remark, throwable == null ? "\u65e0" : throwable.toString()});
                    channelContext.setWaitingClose(false);
                    return;
                }
                if (!channelContext.isRemoved()) break block22;
                log.info("{}, {}\u5df2\u7ecf\u5220\u9664\uff0c\u5907\u6ce8:{}\uff0c\u5f02\u5e38:{}", new Object[]{channelContext.tioConfig, channelContext, remark, throwable == null ? "\u65e0" : throwable.toString()});
                channelContext.setWaitingClose(false);
                return;
            }
            try {
                channelContext.decodeRunnable.setCanceled(true);
                channelContext.handlerRunnable.setCanceled(true);
                channelContext.sendRunnable.setCanceled(true);
                channelContext.decodeRunnable.clearMsgQueue();
                channelContext.handlerRunnable.clearMsgQueue();
                channelContext.sendRunnable.clearMsgQueue();
                log.info("{}, {} \u51c6\u5907\u5173\u95ed\u8fde\u63a5, isNeedRemove:{}, {}", new Object[]{channelContext.tioConfig, channelContext, isNeedRemove, remark});
                try {
                    if (isNeedRemove) {
                        MaintainUtils.remove(channelContext);
                    } else {
                        TioClientConfig tioClientConfig = (TioClientConfig)channelContext.tioConfig;
                        tioClientConfig.closeds.add(channelContext);
                        tioClientConfig.connecteds.remove((Object)channelContext);
                        MaintainUtils.close(channelContext);
                    }
                    channelContext.setRemoved(isNeedRemove);
                    if (channelContext.tioConfig.statOn) {
                        channelContext.tioConfig.groupStat.closed.increment();
                    }
                    channelContext.stat.timeClosed = System.currentTimeMillis();
                    channelContext.setClosed(true);
                    continue;
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                    continue;
                }
                finally {
                    if (isNeedRemove || !channelContext.isClosed() || channelContext.isServer()) continue;
                    ClientChannelContext clientChannelContext = (ClientChannelContext)channelContext;
                    ReconnConf.put(clientChannelContext);
                }
                {
                    catch (Throwable e) {
                        log.error(throwable == null ? remark : throwable.getMessage(), e);
                    }
                }
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                channelContext.setWaitingClose(false);
            }
        }
    }

    public String logstr() {
        return super.logstr();
    }

    public Queue<ChannelContext> getMsgQueue() {
        return this.msgQueue;
    }
}

