/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client.task;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupStat;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientHandler;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.core.stat.ChannelStat;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;

public class ClientHeartbeatTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ClientHeartbeatTask.class);
    private final Timer timer;
    private final TioClientConfig tioClientConfig;
    private final ClientGroupStat clientGroupStat;
    private final TioClientHandler tioHandler;
    private final String id;

    public ClientHeartbeatTask(Timer timer, TioClientConfig tioClientConfig) {
        super(tioClientConfig.heartbeatTimeout / 3L);
        this.timer = timer;
        this.tioClientConfig = tioClientConfig;
        this.clientGroupStat = (ClientGroupStat)tioClientConfig.groupStat;
        this.tioHandler = tioClientConfig.getTioClientHandler();
        this.id = tioClientConfig.getId();
    }

    public void run() {
        this.timer.add((TimerTask)this);
        if (this.tioClientConfig.isStopped()) {
            return;
        }
        Set<ChannelContext> set = this.tioClientConfig.connecteds;
        long currTime = System.currentTimeMillis();
        try {
            for (ChannelContext entry : set) {
                Packet packet;
                ClientChannelContext channelContext = (ClientChannelContext)entry;
                if (channelContext.isClosed() || channelContext.isRemoved()) continue;
                ChannelStat stat = channelContext.stat;
                long compareTime = Math.max(stat.latestTimeOfReceivedByte, stat.latestTimeOfSentPacket);
                long interval = currTime - compareTime;
                if (interval < this.tioClientConfig.heartbeatTimeout / 2L || (packet = this.tioHandler.heartbeatPacket(channelContext)) == null) continue;
                boolean result = Tio.send(channelContext, packet);
                if (!this.tioClientConfig.debug || !logger.isInfoEnabled()) continue;
                logger.info("{} \u53d1\u9001\u5fc3\u8df3\u5305 result:{}", (Object)channelContext, (Object)result);
            }
            if (this.tioClientConfig.debug && logger.isInfoEnabled()) {
                if (this.tioClientConfig.statOn) {
                    logger.info("[{}]: curr:{}, closed:{}, received:({}p)({}b), handled:{}, sent:({}p)({}b)", new Object[]{this.id, set.size(), this.clientGroupStat.closed.sum(), this.clientGroupStat.receivedPackets.sum(), this.clientGroupStat.receivedBytes.sum(), this.clientGroupStat.handledPackets.sum(), this.clientGroupStat.sentPackets.sum(), this.clientGroupStat.sentBytes.sum()});
                } else {
                    logger.info("[{}]: curr:{}, closed:{}", new Object[]{this.id, set.size(), this.clientGroupStat.closed.sum()});
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

