/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.client.task.ClientReConnTask;
import org.tio.core.ChannelContext;
import org.tio.utils.timer.TimerTaskService;

public class ReconnConf {
    private static final Logger log = LoggerFactory.getLogger(ReconnConf.class);
    private final long interval;
    private final int retryCount;
    private TimerTaskService taskService;
    private TioClient tioClient;

    public ReconnConf() {
        this(5000L, 0);
    }

    public ReconnConf(long interval) {
        this(interval, 0);
    }

    public ReconnConf(long interval, int retryCount) {
        this.interval = interval;
        this.retryCount = retryCount;
    }

    public TimerTaskService getTaskService() {
        return this.taskService;
    }

    void setTaskService(TimerTaskService taskService) {
        this.taskService = taskService;
    }

    public TioClient getTioClient() {
        return this.tioClient;
    }

    void setTioClient(TioClient tioClient) {
        this.tioClient = tioClient;
    }

    public static ReconnConf getReconnConf(ClientChannelContext clientChannelContext) {
        TioClientConfig tioClientConfig = (TioClientConfig)clientChannelContext.tioConfig;
        return tioClientConfig.getReconnConf();
    }

    public static ReconnConf getReconnConf(ChannelContext channelContext) {
        return ReconnConf.getReconnConf((ClientChannelContext)channelContext);
    }

    public static boolean isNeedReconn(ClientChannelContext clientChannelContext, boolean putIfNeedConn) {
        if (clientChannelContext == null) {
            return false;
        }
        ReconnConf reconnConf = ReconnConf.getReconnConf(clientChannelContext);
        if (reconnConf == null) {
            return false;
        }
        if (reconnConf.getInterval() > 0L) {
            if (reconnConf.getRetryCount() <= 0 || reconnConf.getRetryCount() > clientChannelContext.getReconnCount().get()) {
                if (putIfNeedConn) {
                    TioClientConfig tioClientConfig = (TioClientConfig)clientChannelContext.tioConfig;
                    tioClientConfig.closeds.add(clientChannelContext);
                    TimerTaskService timerTaskService = reconnConf.getTaskService();
                    Objects.requireNonNull(timerTaskService, "ReconnConf timerTaskService is null.");
                    timerTaskService.addTask(systemTimer -> new ClientReConnTask(clientChannelContext, reconnConf));
                }
                return true;
            }
            log.info("\u4e0d\u9700\u8981\u91cd\u8fde{}", (Object)clientChannelContext);
            return false;
        }
        return false;
    }

    public static boolean put(ClientChannelContext clientChannelContext) {
        if (clientChannelContext == null) {
            return false;
        }
        return ReconnConf.isNeedReconn(clientChannelContext, true);
    }

    public long getInterval() {
        return this.interval;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

