/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.proxy;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.IgnorePacket;
import org.tio.core.intf.Packet;
import org.tio.server.proxy.ProxyProtocolMessage;
import org.tio.utils.buffer.ByteBufferUtil;

public final class ProxyProtocolDecoder {
    private static final int V1_MAX_LENGTH = 108;
    private static final String PROXY_PROTOCOL_KEY = "proxy_protocol_key";
    private static final String UNKNOWN = "UNKNOWN";

    public static void enableProxyProtocol(ChannelContext context) {
        context.set(PROXY_PROTOCOL_KEY, (byte)1);
    }

    public static void removeProxyProtocol(ChannelContext context) {
        context.remove(PROXY_PROTOCOL_KEY);
    }

    public static boolean isProxyProtocolEnabled(ChannelContext context) {
        return context.containsKey(PROXY_PROTOCOL_KEY);
    }

    public static Packet decode(ByteBuffer buffer, int readableLength, ChannelContext context) throws TioDecodeException {
        ProxyProtocolMessage message = ProxyProtocolDecoder.decodeMessage(buffer, readableLength);
        if (message == null) {
            return null;
        }
        context.remove(PROXY_PROTOCOL_KEY);
        String protocol = message.getProtocol();
        if (UNKNOWN.equals(protocol)) {
            context.setProxyClientNode(new Node(UNKNOWN, message.getDestinationPort()));
        } else {
            context.setClientNode(new Node(message.getSourceAddress(), message.getSourcePort()));
            context.setProxyClientNode(new Node(message.getDestinationAddress(), message.getDestinationPort()));
        }
        return IgnorePacket.INSTANCE;
    }

    public static ProxyProtocolMessage decodeMessage(ByteBuffer buffer, int readableLength) throws TioDecodeException {
        int endOfLine = ProxyProtocolDecoder.findEndOfLine(buffer);
        if (endOfLine > 108 || readableLength > 108 && endOfLine == -1) {
            throw new TioDecodeException("Error v1 proxy protocol, readableLength: " + readableLength);
        }
        if (endOfLine == -1) {
            return null;
        }
        String header = ByteBufferUtil.readString((ByteBuffer)buffer, (int)endOfLine, (Charset)StandardCharsets.US_ASCII);
        ByteBufferUtil.skipBytes((ByteBuffer)buffer, (int)2);
        String[] parts = header.split(" ");
        int numParts = parts.length;
        if (numParts < 2) {
            throw new TioDecodeException("invalid header: " + header + " (expected: 'PROXY' and proxied protocol values)");
        }
        if (!"PROXY".equals(parts[0])) {
            throw new TioDecodeException("unknown identifier: " + parts[0]);
        }
        String proxiedProtocol = parts[1];
        if (!("TCP4".equals(proxiedProtocol) || "TCP6".equals(proxiedProtocol) || UNKNOWN.equals(proxiedProtocol))) {
            throw new TioDecodeException("unsupported v1 proxied protocol: " + proxiedProtocol);
        }
        if (UNKNOWN.equals(proxiedProtocol)) {
            return ProxyProtocolDecoder.unknownMsg();
        }
        if (numParts != 6) {
            throw new TioDecodeException("invalid TCP4/6 header: " + header + " (expected: 6 parts)");
        }
        return new ProxyProtocolMessage(proxiedProtocol, parts[2], parts[3], parts[4], parts[5]);
    }

    private static ProxyProtocolMessage unknownMsg() {
        return new ProxyProtocolMessage(UNKNOWN, null, null, 0, 0);
    }

    private static int findEndOfLine(ByteBuffer buffer) {
        int n = buffer.limit();
        for (int i = buffer.position(); i < n; ++i) {
            byte b = buffer.get(i);
            if (b != 13 || i >= n - 1 || buffer.get(i + 1) != 10) continue;
            return i;
        }
        return -1;
    }
}

