/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster.codec;

import java.nio.ByteBuffer;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.cluster.message.ClusterDataMessage;
import org.tio.server.cluster.message.ClusterJoinMessage;
import org.tio.server.cluster.message.ClusterMessageType;
import org.tio.server.cluster.message.ClusterPingMessage;
import org.tio.server.cluster.message.ClusterPongMessage;
import org.tio.server.cluster.message.ClusterSyncAckMessage;
import org.tio.server.cluster.message.ClusterSyncMessage;
import org.tio.utils.buffer.ByteBufferUtil;

public class ClusterMessageDecoder {
    public Packet decode(ChannelContext ctx, ByteBuffer buffer, int readableLength) throws TioDecodeException {
        if (readableLength < 1) {
            return null;
        }
        ClusterMessageType messageType = ClusterMessageType.from(buffer.get());
        switch (messageType) {
            case PING: {
                return ClusterPingMessage.INSTANCE;
            }
            case PONG: {
                return ClusterPongMessage.INSTANCE;
            }
            case DATA: {
                return ClusterMessageDecoder.decodeDataMessage(ctx, buffer, readableLength);
            }
            case SYNC: {
                return ClusterMessageDecoder.decodeSyncMessage(ctx, buffer, readableLength);
            }
            case SYNC_ACK: {
                return ClusterMessageDecoder.decodeSyncAckMessage(ctx, buffer, readableLength);
            }
            case JOIN: {
                return ClusterMessageDecoder.decodeJoinMessage(ctx, buffer, readableLength);
            }
        }
        throw new TioDecodeException("\u6682\u4e0d\u652f\u6301\u7684\u96c6\u7fa4\u6d88\u606f\u7c7b\u578b");
    }

    private static ClusterDataMessage decodeDataMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        if (readableLength < 3) {
            return null;
        }
        int dataLength = ByteBufferUtil.readUnsignedShortLE((ByteBuffer)buffer);
        int messageLength = 3 + dataLength;
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(messageLength);
            return null;
        }
        byte[] payload = ByteBufferUtil.readBytes((ByteBuffer)buffer, (int)dataLength);
        return new ClusterDataMessage(payload);
    }

    private static ClusterSyncMessage decodeSyncMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        if (readableLength < 11) {
            return null;
        }
        long messageId = buffer.getLong();
        int dataLength = ByteBufferUtil.readUnsignedShortLE((ByteBuffer)buffer);
        int messageLength = 11 + dataLength;
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(messageLength);
            return null;
        }
        byte[] payload = ByteBufferUtil.readBytes((ByteBuffer)buffer, (int)dataLength);
        return new ClusterSyncMessage(messageId, payload);
    }

    private static ClusterSyncAckMessage decodeSyncAckMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        if (readableLength < 9) {
            ctx.setPacketNeededLength(9);
            return null;
        }
        long messageId = buffer.getLong();
        return new ClusterSyncAckMessage(messageId);
    }

    private static ClusterJoinMessage decodeJoinMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        int messageLength = 35;
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(messageLength);
            return null;
        }
        int port = ByteBufferUtil.readUnsignedShortLE((ByteBuffer)buffer);
        String ip = ByteBufferUtil.readString((ByteBuffer)buffer, (int)32);
        return new ClusterJoinMessage(new Node(ip.trim(), port));
    }
}

