/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp;

import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import org.tio.core.Node;
import org.tio.core.udp.UdpClientConf;
import org.tio.core.udp.task.UdpSendRunnable;

public class UdpClient {
    private final LinkedBlockingQueue<DatagramPacket> queue = new LinkedBlockingQueue();
    private final InetSocketAddress inetSocketAddress;
    private final UdpSendRunnable udpSendRunnable;

    public UdpClient(UdpClientConf udpClientConf) {
        Node node = udpClientConf.getServerNode();
        this.inetSocketAddress = new InetSocketAddress(node.getIp(), node.getPort());
        this.udpSendRunnable = new UdpSendRunnable(this.queue, udpClientConf, null);
    }

    public void send(byte[] data) {
        DatagramPacket datagramPacket = new DatagramPacket(data, data.length, this.inetSocketAddress);
        this.queue.add(datagramPacket);
    }

    public void send(String str) {
        this.send(str, StandardCharsets.UTF_8);
    }

    public void send(String data, Charset charset) {
        if (data == null) {
            return;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        this.send(data.getBytes(charset));
    }

    public void start() {
        Thread thread = new Thread((Runnable)this.udpSendRunnable, "tio-udp-client-send");
        thread.setDaemon(false);
        thread.start();
    }
}

