/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor.uploader;

import net.dreamlu.module.ueditor.ActionConfig;
import net.dreamlu.module.ueditor.PathFormat;
import net.dreamlu.module.ueditor.define.BaseState;
import net.dreamlu.module.ueditor.define.FileType;
import net.dreamlu.module.ueditor.define.State;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;
import org.springframework.util.Base64Utils;

public final class Base64Uploader {
    public static State save(IUeditorFileManager fileManager, String content, ActionConfig conf) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = conf.getMaxSize())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        String savePath = PathFormat.parse(conf.getSavePath(), conf.getFilename());
        savePath = savePath + suffix;
        String rootPath = conf.getRootPath();
        State storageState = fileManager.saveFile(data, rootPath, savePath);
        if (storageState.isSuccess()) {
            storageState.putInfo("url", PathFormat.format(savePath));
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", "");
        }
        return storageState;
    }

    private static byte[] decode(String content) {
        return Base64Utils.decodeFromString((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

