/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor.hunter;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import net.dreamlu.module.ueditor.ActionConfig;
import net.dreamlu.module.ueditor.PathFormat;
import net.dreamlu.module.ueditor.define.BaseState;
import net.dreamlu.module.ueditor.define.MIMEType;
import net.dreamlu.module.ueditor.define.MultiState;
import net.dreamlu.module.ueditor.define.State;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;

public class ImageHunter {
    private String filename = null;
    private String savePath = null;
    private String rootPath = null;
    private List<String> allowTypes = null;
    private long maxSize = -1L;
    private IUeditorFileManager fileManager;
    private List<String> filters = null;

    public ImageHunter(IUeditorFileManager fileManager, ActionConfig conf) {
        this.fileManager = fileManager;
        this.filename = conf.getFilename();
        this.savePath = conf.getSavePath();
        this.rootPath = conf.getRootPath();
        this.maxSize = conf.getMaxSize();
        this.allowTypes = conf.getAllowFiles();
        this.filters = conf.getFilter();
    }

    public State capture(String[] list) {
        MultiState state = new MultiState(true);
        for (String source : list) {
            state.addState(this.captureRemoteData(source));
        }
        return state;
    }

    public State captureRemoteData(String urlStr) {
        HttpURLConnection connection = null;
        URL url = null;
        String suffix = null;
        try {
            url = new URL(urlStr);
            if (!this.validHost(url.getHost())) {
                return new BaseState(false, 201);
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(true);
            if (!this.validContentState(connection.getResponseCode())) {
                return new BaseState(false, 202);
            }
            suffix = MIMEType.getSuffix(connection.getContentType());
            if (!this.validFileType(suffix)) {
                return new BaseState(false, 8);
            }
            if (!this.validFileSize(connection.getContentLength())) {
                return new BaseState(false, 1);
            }
            String savePath = this.getPath(this.savePath, this.filename, suffix);
            State state = this.fileManager.saveFile(connection.getInputStream(), this.rootPath, savePath);
            if (state.isSuccess()) {
                state.putInfo("url", PathFormat.format(savePath));
                state.putInfo("source", urlStr);
            }
            return state;
        }
        catch (Exception e) {
            return new BaseState(false, 203);
        }
    }

    private String getPath(String savePath, String filename, String suffix) {
        return PathFormat.parse(savePath + suffix, filename);
    }

    private boolean validHost(String hostname) {
        return !this.filters.contains(hostname);
    }

    private boolean validContentState(int code) {
        return 200 == code;
    }

    private boolean validFileType(String type) {
        return this.allowTypes.contains(type);
    }

    private boolean validFileSize(int size) {
        return (long)size < this.maxSize;
    }
}

