/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor;

import javax.servlet.http.HttpServletRequest;
import net.dreamlu.module.ueditor.ActionConfig;
import net.dreamlu.module.ueditor.JsonUtils;
import net.dreamlu.module.ueditor.UeditorConfig;
import net.dreamlu.module.ueditor.UeditorManager;
import net.dreamlu.module.ueditor.define.ActionMap;
import net.dreamlu.module.ueditor.define.BaseState;
import net.dreamlu.module.ueditor.define.State;
import net.dreamlu.module.ueditor.hunter.ImageHunter;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;
import net.dreamlu.module.ueditor.uploader.Uploader;
import org.springframework.util.StringUtils;

public class UeditorService {
    private UeditorManager ueditorManager;

    public UeditorService() {
    }

    public UeditorService(UeditorManager ueditorManager) {
        this.ueditorManager = ueditorManager;
    }

    public String exec(HttpServletRequest request) {
        String callbackName = request.getParameter("callback");
        if (callbackName != null) {
            if (!this.validCallbackName(callbackName)) {
                return new BaseState(false, 401).toJSONString();
            }
            return callbackName + "(" + this.invoke(request) + ");";
        }
        return this.invoke(request);
    }

    private String invoke(HttpServletRequest request) {
        String actionType = request.getParameter("action");
        String rootPath = request.getServletContext().getRealPath("/");
        String ctxPath = request.getContextPath();
        if (actionType == null || !ActionMap.mapping.containsKey(actionType)) {
            return new BaseState(false, 101).toJSONString();
        }
        if (this.ueditorManager == null || !this.ueditorManager.valid()) {
            return new BaseState(false, 102).toJSONString();
        }
        IUeditorFileManager fileManager = this.ueditorManager.getFileManager();
        State state = null;
        int actionCode = ActionMap.getType(actionType);
        ActionConfig conf = null;
        switch (actionCode) {
            case 0: {
                UeditorConfig allConfig = this.ueditorManager.getConfig();
                String imageUrlPrefix = allConfig.getImageUrlPrefix();
                String scrawlUrlPrefix = allConfig.getScrawlUrlPrefix();
                String snapscreenUrlPrefix = allConfig.getSnapscreenUrlPrefix();
                String catcherUrlPrefix = allConfig.getCatcherUrlPrefix();
                String videoUrlPrefix = allConfig.getVideoUrlPrefix();
                String fileUrlPrefix = allConfig.getFileUrlPrefix();
                String imageManagerUrlPrefix = allConfig.getImageManagerUrlPrefix();
                String fileManagerUrlPrefix = allConfig.getFileManagerUrlPrefix();
                if (StringUtils.hasText((String)imageUrlPrefix)) {
                    allConfig.setImageUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)scrawlUrlPrefix)) {
                    allConfig.setScrawlUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)snapscreenUrlPrefix)) {
                    allConfig.setSnapscreenUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)catcherUrlPrefix)) {
                    allConfig.setCatcherUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)videoUrlPrefix)) {
                    allConfig.setVideoUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)fileUrlPrefix)) {
                    allConfig.setFileUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)imageManagerUrlPrefix)) {
                    allConfig.setImageManagerUrlPrefix(ctxPath);
                }
                if (StringUtils.hasText((String)fileManagerUrlPrefix)) {
                    allConfig.setFileManagerUrlPrefix(ctxPath);
                }
                return JsonUtils.toJson(allConfig);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                conf = this.ueditorManager.getConfig(actionCode, rootPath);
                state = new Uploader(request, conf).doExec(fileManager);
                break;
            }
            case 5: {
                conf = this.ueditorManager.getConfig(actionCode, rootPath);
                String[] list = request.getParameterValues(conf.getFieldName());
                state = new ImageHunter(fileManager, conf).capture(list);
                break;
            }
            case 6: 
            case 7: {
                conf = this.ueditorManager.getConfig(actionCode, rootPath);
                int start = this.getStartIndex(request);
                state = fileManager.list(conf, start);
            }
        }
        return state.toJSONString();
    }

    public int getStartIndex(HttpServletRequest request) {
        String start = request.getParameter("start");
        try {
            return Integer.parseInt(start);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean validCallbackName(String name) {
        return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
    }

    public void setUeditorManager(UeditorManager ueditorManager) {
        this.ueditorManager = ueditorManager;
    }

    public UeditorManager getUeditorManager() {
        return this.ueditorManager;
    }
}

