/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.dreamlu.module.ueditor.ActionConfig;
import net.dreamlu.module.ueditor.JsonUtils;
import net.dreamlu.module.ueditor.UeditorConfig;
import net.dreamlu.module.ueditor.manager.DefaultFileManager;
import net.dreamlu.module.ueditor.manager.IUeditorFileManager;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class UeditorManager
implements InitializingBean {
    private static final String CONFIG_FILE_JSON = "/ueditor.config.json";
    private UeditorConfig jsonConfig = null;
    private IUeditorFileManager fileManager = new DefaultFileManager();

    public IUeditorFileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(IUeditorFileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void afterPropertiesSet() throws Exception {
        try (InputStream input = UeditorManager.class.getResourceAsStream(CONFIG_FILE_JSON);){
            Assert.notNull((Object)input, (String)"can't find ueditor.config.json");
            String configContent = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            this.jsonConfig = JsonUtils.parse(UeditorManager.filter(configContent), UeditorConfig.class);
        }
    }

    public boolean valid() {
        return this.jsonConfig != null;
    }

    public UeditorConfig getConfig() {
        return this.jsonConfig;
    }

    public ActionConfig getConfig(int type, String rootPath) {
        ActionConfig conf = new ActionConfig();
        String savePath = null;
        switch (type) {
            case 4: {
                conf.setBase64(false);
                conf.setMaxSize(this.jsonConfig.getFileMaxSize());
                conf.setAllowFiles(this.jsonConfig.getFileAllowFiles());
                conf.setFieldName(this.jsonConfig.getFileFieldName());
                savePath = this.jsonConfig.getFilePathFormat();
                break;
            }
            case 1: {
                conf.setBase64(false);
                conf.setMaxSize(this.jsonConfig.getImageMaxSize());
                conf.setAllowFiles(this.jsonConfig.getImageAllowFiles());
                conf.setFieldName(this.jsonConfig.getImageFieldName());
                savePath = this.jsonConfig.getImagePathFormat();
                break;
            }
            case 3: {
                conf.setMaxSize(this.jsonConfig.getVideoMaxSize());
                conf.setAllowFiles(this.jsonConfig.getVideoAllowFiles());
                conf.setFieldName(this.jsonConfig.getVideoFieldName());
                savePath = this.jsonConfig.getVideoPathFormat();
                break;
            }
            case 2: {
                conf.setFilename("scrawl");
                conf.setMaxSize(this.jsonConfig.getScrawlMaxSize());
                conf.setFieldName(this.jsonConfig.getScrawlFieldName());
                conf.setBase64(true);
                savePath = this.jsonConfig.getScrawlPathFormat();
                break;
            }
            case 5: {
                conf.setFilename("remote");
                conf.setFilter(this.jsonConfig.getCatcherLocalDomain());
                conf.setMaxSize(this.jsonConfig.getCatcherMaxSize());
                conf.setAllowFiles(this.jsonConfig.getCatcherAllowFiles());
                conf.setFieldName(this.jsonConfig.getCatcherFieldName() + "[]");
                savePath = this.jsonConfig.getCatcherPathFormat();
                break;
            }
            case 7: {
                conf.setAllowFiles(this.jsonConfig.getImageManagerAllowFiles());
                conf.setDir(this.jsonConfig.getImageManagerListPath());
                conf.setCount(this.jsonConfig.getImageManagerListSize());
                break;
            }
            case 6: {
                conf.setAllowFiles(this.jsonConfig.getFileManagerAllowFiles());
                conf.setDir(this.jsonConfig.getFileManagerListPath());
                conf.setCount(this.jsonConfig.getFileManagerListSize());
            }
        }
        conf.setSavePath(savePath);
        conf.setRootPath(rootPath);
        return conf;
    }

    private static String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }
}

