/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathFormat {
    private static final String TIME = "time";
    private static final String FULL_YEAR = "yyyy";
    private static final String YEAR = "yy";
    private static final String MONTH = "mm";
    private static final String DAY = "dd";
    private static final String HOUR = "hh";
    private static final String MINUTE = "ii";
    private static final String SECOND = "ss";
    private static final String RAND = "rand";

    public static String parse(String input) {
        return PathFormat.parse(input, null);
    }

    public static String parse(String input, String filename) {
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}", 2);
        Matcher matcher = pattern.matcher(input);
        Date currentDate = new Date();
        StringBuffer sb = new StringBuffer();
        String matchStr = null;
        while (matcher.find()) {
            matchStr = matcher.group(1);
            if (null != filename && matchStr.indexOf("filename") != -1) {
                filename = filename.replace("$", "\\$").replaceAll("[\\/:*?\"<>|]", "");
                matcher.appendReplacement(sb, filename);
                continue;
            }
            matcher.appendReplacement(sb, PathFormat.getString(matchStr, currentDate));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getString(String pattern, Date currentDate) {
        if ((pattern = pattern.toLowerCase()).indexOf(TIME) != -1) {
            return PathFormat.getTimestamp();
        }
        if (pattern.indexOf(FULL_YEAR) != -1) {
            return PathFormat.format(currentDate, FULL_YEAR);
        }
        if (pattern.indexOf(YEAR) != -1) {
            return PathFormat.format(currentDate, YEAR);
        }
        if (pattern.indexOf(MONTH) != -1) {
            return PathFormat.format(currentDate, "MM");
        }
        if (pattern.indexOf(DAY) != -1) {
            return PathFormat.format(currentDate, DAY);
        }
        if (pattern.indexOf(HOUR) != -1) {
            return PathFormat.format(currentDate, "HH");
        }
        if (pattern.indexOf(MINUTE) != -1) {
            return PathFormat.format(currentDate, MONTH);
        }
        if (pattern.indexOf(SECOND) != -1) {
            return PathFormat.format(currentDate, SECOND);
        }
        if (pattern.indexOf(RAND) != -1) {
            return PathFormat.getRandom(pattern);
        }
        return pattern;
    }

    private static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String format(String input) {
        return input.replace("\\", "/");
    }

    private static String format(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    private static String getRandom(String pattern) {
        int length = 0;
        pattern = pattern.split(":")[1].trim();
        length = Integer.parseInt(pattern);
        return (Math.random() + "").replace(".", "").substring(0, length);
    }
}

