/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.module.ueditor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.util.ClassUtils;

public class JsonUtils {
    private static final JsonDelegate delegate;

    public static String toJson(Object object) {
        if (delegate == null) {
            throw new RuntimeException("Jackson or Fastjson not supported");
        }
        return delegate.toJson(object);
    }

    public static <T> T parse(String jsonString, Class<T> valueType) {
        if (delegate == null) {
            throw new RuntimeException("Jackson or Fastjson not supported");
        }
        return delegate.parse(jsonString, valueType);
    }

    static {
        JsonDelegate delegateToUse = null;
        if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)JsonUtils.class.getClassLoader())) {
            delegateToUse = new JacksonDelegate();
        } else if (ClassUtils.isPresent((String)"com.alibaba.fastjson.JSONObject", (ClassLoader)JsonUtils.class.getClassLoader())) {
            delegateToUse = new FastJsonDelegate();
        }
        delegate = delegateToUse;
    }

    private static class FastJsonDelegate
    implements JsonDelegate {
        private FastJsonDelegate() {
        }

        @Override
        public String toJson(Object object) {
            return JSONObject.toJSONString((Object)object);
        }

        @Override
        public <T> T parse(String jsonString, Class<T> valueType) {
            return (T)JSON.parseObject((String)jsonString, valueType);
        }
    }

    private static class JacksonDelegate
    implements JsonDelegate {
        private ObjectMapper objectMapper = new ObjectMapper();

        private JacksonDelegate() {
        }

        @Override
        public String toJson(Object object) {
            try {
                return this.objectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T> T parse(String jsonString, Class<T> valueType) {
            try {
                return (T)this.objectMapper.readValue(jsonString, valueType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface JsonDelegate {
        public String toJson(Object var1);

        public <T> T parse(String var1, Class<T> var2);
    }
}

