/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class InputOutputs {
    private static byte[] empty = new byte[0];
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        finally {
            InputOutputs.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAll(InputStream input, int initialSize) throws IOException {
        initialSize = Math.max(initialSize, 32);
        int total = 0;
        int segmentSize = initialSize;
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        try {
            int toRead;
            int read;
            do {
                int b;
                if ((b = input.read()) == -1) {
                    break;
                }
                byte[] segment = new byte[segmentSize];
                if (total > 0) {
                    segmentSize = Math.min(segmentSize * 2, 0x100000);
                }
                segment[0] = (byte)b;
                toRead = segment.length - 1;
                read = InputOutputs.readExact(input, segment, 1, toRead);
                if (Integer.MAX_VALUE - read < total) {
                    throw new RuntimeException("Data large than array max size");
                }
                total += read + 1;
                dataList.add(segment);
            } while (read == toRead);
        }
        finally {
            InputOutputs.closeQuietly(input);
        }
        if (dataList.size() == 0) {
            return empty;
        }
        if (dataList.size() == 1 && total == initialSize) {
            return (byte[])dataList.get(0);
        }
        byte[] data = new byte[total];
        int offset = 0;
        for (byte[] segment : dataList) {
            int size = Math.min(segment.length, total - offset);
            System.arraycopy(segment, 0, data, offset, size);
            offset += size;
        }
        return data;
    }

    public static byte[] readAll(InputStream input) throws IOException {
        return InputOutputs.readAll(input, 32);
    }

    public static int readExact(InputStream input, byte[] data, int offset, int len) throws IOException {
        int read;
        int total = 0;
        while (len > 0 && (read = input.read(data, offset, len)) != -1) {
            total += read;
            offset += read;
            len -= read;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long skipAll(InputStream input) throws IOException {
        long count = 0L;
        try {
            long read;
            while ((read = input.skip(Math.max(input.available(), 8192))) != 0L) {
                count += read;
            }
            int b = input.read();
            if (b == -1) {
                long l = count;
                return l;
            }
            byte[] buffer = new byte[8192];
            while ((read = (long)input.read(buffer)) != -1L) {
                count += read;
            }
        }
        finally {
            InputOutputs.closeQuietly(input);
        }
        return count;
    }

    public static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[8192];
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, read);
            }
        }
        finally {
            InputOutputs.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
        }
        finally {
            InputOutputs.closeQuietly(reader);
        }
        return sb.toString();
    }

    /*
     * Loose catch block
     */
    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            try (BufferedReader br = InputOutputs.buffered(reader);){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            InputOutputs.closeQuietly(reader);
        }
    }

    public static BufferedReader buffered(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long skipAll(Reader reader) throws IOException {
        long count = 0L;
        try {
            long read;
            while ((read = reader.skip(8192L)) != 0L) {
                count += read;
            }
            int c = reader.read();
            if (c == -1) {
                long l = count;
                return l;
            }
            char[] buffer = new char[8192];
            while ((read = (long)reader.read(buffer)) != -1L) {
                count += read;
            }
        }
        finally {
            InputOutputs.closeQuietly(reader);
        }
        return count;
    }
}

