/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.dongliu.requests.json.AbstractJsonProvider;
import net.dongliu.requests.json.JsonProvider;

public class JacksonProvider
extends AbstractJsonProvider
implements JsonProvider {
    private final ObjectMapper objectMapper;

    public JacksonProvider() {
        this(JacksonProvider.createDefault());
    }

    private static ObjectMapper createDefault() {
        return new ObjectMapper().findAndRegisterModules();
    }

    public JacksonProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void marshal(Writer writer, @Nullable Object value) throws IOException {
        this.objectMapper.writeValue(writer, value);
    }

    @Override
    public <T> T unmarshal(Reader reader, Type type) throws IOException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
        return (T)this.objectMapper.readValue(reader, javaType);
    }
}

