/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.body;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import net.dongliu.requests.body.Part;
import net.dongliu.requests.body.RequestBody;

class MultiPartRequestBody
extends RequestBody<Collection<? extends Part>> {
    private static final String BOUNDARY = "********************" + System.currentTimeMillis();
    private static final String LINE_END = "\r\n";

    public MultiPartRequestBody(Collection<? extends Part> body) {
        super(body, "multipart/form-data; boundary=" + BOUNDARY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBody(OutputStream os, Charset charset) throws IOException {
        try (NonCloseOutputStream output = new NonCloseOutputStream(os);
             OutputStreamWriter writer = new OutputStreamWriter(output);){
            for (Part part : (Collection)this.getBody()) {
                RequestBody body = part.getRequestBody();
                String name = part.getName();
                String fileName = part.getFileName();
                this.writeBoundary(writer);
                writer.write("Content-Disposition: form-data; name=\"" + name + "\"");
                if (fileName != null && !fileName.isEmpty()) {
                    writer.write("; filename=\"" + fileName + '\"');
                }
                writer.write(LINE_END);
                if (body.getContentType() != null && !body.getContentType().isEmpty()) {
                    writer.write("Content-Type: " + body.getContentType());
                    if (body.isIncludeCharset()) {
                        writer.write("; charset=" + charset.name().toLowerCase());
                    }
                    writer.write(LINE_END);
                }
                writer.write(LINE_END);
                ((Writer)writer).flush();
                body.writeBody(output, charset);
                writer.write(LINE_END);
                ((Writer)writer).flush();
                ((OutputStream)output).flush();
            }
            writer.write("--");
            writer.write(BOUNDARY);
            writer.write("--");
            writer.write(LINE_END);
        }
    }

    private void writeBoundary(Writer writer) throws IOException {
        writer.write("--");
        writer.write(BOUNDARY);
        writer.write(LINE_END);
    }

    private static class NonCloseOutputStream
    extends FilterOutputStream {
        public NonCloseOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

