/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.body;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import net.dongliu.requests.body.RequestBody;
import net.dongliu.requests.utils.InputOutputs;

class FileRequestBody
extends RequestBody<File> {
    FileRequestBody(File body) {
        super(body, FileRequestBody.getFileContentType(body), false);
    }

    private static String getFileContentType(File body) {
        String contentType;
        try {
            contentType = Files.probeContentType(body.toPath());
        }
        catch (IOException e) {
            contentType = null;
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    @Override
    public void writeBody(OutputStream os, Charset charset) throws IOException {
        InputOutputs.copy(new FileInputStream((File)this.getBody()), os);
    }
}

